/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.AbstractRecoverer;
import org.eclipse.edt.ide.core.internal.errors.ErrorMarkerCollector;
import org.eclipse.edt.ide.core.internal.errors.ErrorTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.Reporter;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;

public class UnexpectedTerminalRecoverer
extends AbstractRecoverer {
    @Override
    public int recoverDistance(ParseStack stack, TokenStream tokenStream) {
        if (UnexpectedTerminalRecoverer.isImportantTerminal(tokenStream.lookAhead())) {
            return 0;
        }
        stack = stack.copy();
        tokenStream = tokenStream.copy();
        tokenStream.deleteInput(1);
        int distance = this.tryParseAhead(stack, tokenStream);
        Reporter.getInstance().unexpectedTerminalDistance(distance);
        return distance;
    }

    @Override
    public void recover(ParseStack stack, TokenStream tokenStream) {
        Reporter.getInstance().recoverUnexpectedTerminal(tokenStream.lookAhead().text);
        this.errorMessage(stack, tokenStream, tokenStream.lookAhead());
        tokenStream.deleteInput(1);
        ParseNode[] deletedInputSymbols = tokenStream.getUnprocessedTerminals();
        ParseNode deletedNode = this.chainNodes(deletedInputSymbols);
        ErrorTerminalNode errorNode = new ErrorTerminalNode(4, deletedNode);
        stack.connect(errorNode);
    }

    @Override
    public void errorMessage(ParseStack stack, TokenStream tokenStream, TerminalNode errorTerminal) {
        String message = "\t\"" + errorTerminal.text + "\" is unexpected";
        ErrorMarkerCollector.instance.add(errorTerminal.offset, errorTerminal.offset + errorTerminal.text.length(), errorTerminal.line, message);
    }
}

