/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.ErrorNode;
import org.eclipse.edt.ide.core.internal.errors.NonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseTreePrinter;
import org.eclipse.edt.ide.core.internal.model.document.EGLNodeNameUtility;

public class ErrorNonTerminalNode
extends NonTerminalNode
implements ErrorNode {
    private String errorMessage = this.getDefaultErrorMessage();

    public ErrorNonTerminalNode(int nonterminalType) {
        super(nonterminalType, null);
    }

    public ErrorNonTerminalNode(int nonterminalType, ParseNode errorSymbols) {
        super(nonterminalType, new ParseNode[]{errorSymbols});
    }

    @Override
    public String toString() {
        return "<" + EGLNodeNameUtility.getNonterminalName(this.nonTerminalType) + ">";
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    private String getDefaultErrorMessage() {
        if (this.children == null) {
            return "Missing " + EGLNodeNameUtility.getNonterminalName(this.nonTerminalType);
        }
        if (this.nonTerminalType == 3) {
            return "The phrase " + ParseTreePrinter.format(this.getText().trim()) + " is unexpected";
        }
        return "The phrase " + ParseTreePrinter.format(this.getText().trim()) + " is not a valid " + EGLNodeNameUtility.getNonterminalName(this.nonTerminalType);
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }
}

