/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyGraphValue;
import org.eclipse.edt.ide.core.internal.dependency.QualifiedName;
import org.eclipse.edt.ide.core.internal.dependency.SimpleName;

class Function
implements IDependencyGraphValue {
    private String projectName;
    private QualifiedName packageName;
    private SimpleName partName;

    public Function(String projectName, String packageName, String partName) {
        this.projectName = projectName;
        this.packageName = new QualifiedName(packageName);
        this.partName = new SimpleName(partName);
    }

    public Function() {
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getPackageName() {
        return this.packageName.getQualifiedName();
    }

    public String getPartName() {
        return this.partName.getSimpleName();
    }

    public String toString() {
        return String.valueOf(this.projectName) + "." + this.packageName + "." + this.partName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Function) {
            return ((Function)obj).projectName.equals(this.projectName) && ((Function)obj).packageName.equals(this.packageName) && ((Function)obj).partName.equals(this.partName);
        }
        return false;
    }

    public int hashCode() {
        return this.partName.hashCode();
    }

    @Override
    public int getNormalizedHashCode() {
        return this.partName.getNormalizedHashCode();
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.writeUTF(this.projectName);
        this.packageName.serialize(outputStream);
        this.partName.serialize(outputStream);
    }

    @Override
    public void deserialize(DataInputStream inputStream) throws IOException {
        this.projectName = inputStream.readUTF();
        this.packageName = new QualifiedName();
        this.packageName.deserialize(inputStream);
        this.partName = new SimpleName();
        this.partName.deserialize(inputStream);
    }

    @Override
    public int getKind() {
        return 0;
    }
}

