/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyGraphEntry;
import org.eclipse.edt.ide.core.internal.dependency.QualifiedName;
import org.eclipse.edt.ide.core.internal.dependency.SimpleName;

public class DependencyEntry
implements IDependencyGraphEntry {
    Set qualifiedNames = Collections.EMPTY_SET;
    Set simpleNames = Collections.EMPTY_SET;

    public void addSimpleName(SimpleName simpleName) {
        if (this.simpleNames == Collections.EMPTY_SET) {
            this.simpleNames = new HashSet();
        }
        this.simpleNames.add(simpleName);
    }

    public void addQualifiedName(QualifiedName qualifiedName) {
        if (this.qualifiedNames == Collections.EMPTY_SET) {
            this.qualifiedNames = new HashSet();
        }
        this.qualifiedNames.add(qualifiedName);
    }

    public Set getSimpleNames() {
        return this.simpleNames;
    }

    public void removeSimpleName(SimpleName simpleName) {
        this.simpleNames.remove(simpleName);
    }

    public void removeQualifiedName(QualifiedName qualifiedName) {
        this.qualifiedNames.remove(qualifiedName);
    }

    public Set getQualifiedNames() {
        return this.qualifiedNames;
    }

    @Override
    public boolean isEmpty() {
        return this.qualifiedNames.size() == 0 && this.simpleNames.size() == 0;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.qualifiedNames.size());
        for (QualifiedName qualifiedName : this.qualifiedNames) {
            qualifiedName.serialize(outputStream);
        }
        outputStream.writeInt(this.simpleNames.size());
        for (SimpleName simpleName : this.simpleNames) {
            simpleName.serialize(outputStream);
        }
    }

    @Override
    public void deserialize(DataInputStream inputStream) throws IOException {
        int numQualifiedNames = inputStream.readInt();
        int i = 0;
        while (i < numQualifiedNames) {
            QualifiedName qualifiedName = new QualifiedName();
            qualifiedName.deserialize(inputStream);
            this.addQualifiedName(qualifiedName);
            ++i;
        }
        int numSimpleNames = inputStream.readInt();
        int i2 = 0;
        while (i2 < numSimpleNames) {
            SimpleName simpleName = new SimpleName();
            simpleName.deserialize(inputStream);
            this.addSimpleName(simpleName);
            ++i2;
        }
    }

    @Override
    public int getKind() {
        return 0;
    }
}

