/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler.workingcopy;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.PartEnvironmentStack;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.compiler.internal.util.PackageAndPartName;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.compiler.Binder;
import org.eclipse.edt.ide.core.internal.compiler.Compiler;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IProblemRequestorFactory;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyASTManager;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.dependency.AbstractDependencyInfo;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyBuildNotifier;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfoManager;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.utils.NameUtile;

public class WorkingCopyProcessingQueue
extends AbstractProcessingQueue {
    private IProject project;
    private IProblemRequestorFactory problemRequestorFactory;
    private IWorkingCopyCompileRequestor requestor;
    private WorkingCopyProjectEnvironment projectEnvironment;
    private WorkingCopyProjectInfo projectInfo;
    private boolean pushedEnvironment;

    public WorkingCopyProcessingQueue(IProject project, IProblemRequestorFactory problemRequestorFactory) {
        super((IBuildNotifier)WorkingCopyBuildNotifier.getInstance(), DefaultCompilerOptions.getInstance());
        this.project = project;
        this.problemRequestorFactory = problemRequestorFactory;
        WorkingCopyProjectBuildPathEntry entry = WorkingCopyProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project);
        entry.setProcessingQueue(this);
        this.projectEnvironment = WorkingCopyProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
        this.projectEnvironment.initIREnvironments();
        this.projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
        Environment.pushEnv((IEnvironment)this.projectEnvironment.getIREnvironment());
        PartEnvironmentStack.pushEnv((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment);
        this.pushedEnvironment = true;
    }

    public boolean pushedEnvironment() {
        return this.pushedEnvironment;
    }

    public void setCompileRequestor(IWorkingCopyCompileRequestor requestor) {
        this.requestor = requestor;
    }

    protected boolean hasExceededMaxLoop() {
        return false;
    }

    protected IPartBinding level03Compile(PackageAndPartName ppName) {
        IFile declaringFile = this.projectInfo.getPartOrigin(ppName.getPackageName(), ppName.getPartName()).getEGLFile();
        Node partAST = WorkingCopyASTManager.getInstance().getAST(declaringFile, ppName.getPartName());
        IPartBinding binding = new BindingCreator((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment, ppName, partAST).getPartBinding();
        binding.setEnvironment((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment);
        if (binding instanceof IRPartBinding) {
            BindingUtil.setEnvironment((Element)((IRPartBinding)binding).getIrPart(), (org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment);
        }
        WorkingCopyDependencyInfo dependencyInfo = new WorkingCopyDependencyInfo();
        Scope scope = this.createScope(ppName.getPackageName(), declaringFile, binding, dependencyInfo);
        IProblemRequestor problemRequestor = this.problemRequestorFactory.getProblemRequestor(declaringFile, ppName.getPartName());
        if (problemRequestor != NullProblemRequestor.getInstance()) {
            Compiler.getInstance().compilePart(partAST, binding, scope, dependencyInfo, problemRequestor, this.compilerOptions);
            if (binding.getKind() == 16) {
                this.validatePackageDeclaration(ppName.getPackageName(), declaringFile, partAST, (FileBinding)binding, problemRequestor);
            }
        } else {
            Binder.getInstance().bindPart(partAST, binding, scope, dependencyInfo, problemRequestor, this.compilerOptions);
        }
        this.requestor.acceptResult(new WorkingCopyCompilationResult(partAST, binding, declaringFile));
        WorkingCopyASTManager.getInstance().reportNestedFunctions(partAST, declaringFile);
        return binding;
    }

    protected IPartBinding level02Compile(PackageAndPartName ppName) {
        return WorkingCopyProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(this.project).compileLevel2Binding(ppName);
    }

    protected IPartBinding level01Compile(PackageAndPartName ppName) {
        return this.projectEnvironment.level01Compile(ppName);
    }

    protected IPartBinding getPartBindingFromCache(String packageName, String partName) {
        return WorkingCopyProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(this.project).getPartBindingFromCache(packageName, partName);
    }

    private Scope createScope(String packageName, IFile declaringFile, IPartBinding binding, AbstractDependencyInfo dependencyInfo) {
        EnvironmentScope scope;
        if (binding.getKind() == 16) {
            scope = new EnvironmentScope((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment, (IDependencyRequestor)dependencyInfo);
        } else {
            String fileName = Util.getFilePartName(declaringFile);
            IPartBinding fileBinding = this.projectEnvironment.getPartBinding(packageName, fileName);
            scope = new FileScope((Scope)new EnvironmentScope((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment, (IDependencyRequestor)dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)dependencyInfo);
        }
        return scope;
    }

    protected void doAddPart(String packageName, String caseInsensitiveInternedPartName) {
        PackageAndPartName ppName = this.projectInfo.getPackageAndPartName(packageName, caseInsensitiveInternedPartName);
        this.addPart(new PackageAndPartName(ppName.getCaseSensitivePackageName(), ppName.getCaseSensitivePartName(), packageName));
    }

    private void validatePackageDeclaration(String packageName, IFile declaringFile, Node partAST, FileBinding binding, IProblemRequestor problemRequestor) {
        try {
            IPackageBinding declaringPackage = binding.getDeclaringPackage();
            if (declaringPackage != null && !NameUtile.equals((String)declaringPackage.getPackageName(), (String)packageName)) {
                if (packageName.length() == 0) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, new String[0]);
                } else if (((File)partAST).hasPackageDeclaration()) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, new String[0]);
                } else {
                    IPath packagePath = declaringFile.getProjectRelativePath().removeFileExtension().removeLastSegments(1);
                    packagePath = packagePath.removeFirstSegments(packagePath.segmentCount() - Util.qualifiedNameToStringArray(packageName).length);
                    problemRequestor.acceptProblem(0, 0, 2, 3064, new String[]{packagePath.toString().replace('/', '.')});
                }
            } else if (((File)partAST).hasPackageDeclaration()) {
                String packageDeclName = ((File)partAST).getPackageDeclaration().getName().getCanonicalName();
                IPath packagePath = declaringFile.getProjectRelativePath().removeFileExtension().removeLastSegments(1);
                if (!packageDeclName.equals((packagePath = packagePath.removeFirstSegments(packagePath.segmentCount() - Util.qualifiedNameToStringArray(packageName).length)).toString().replace('/', ".".charAt(0)))) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, 2, new String[0]);
                }
            }
        }
        catch (RuntimeException e) {
            problemRequestor.acceptProblem(0, 0, 2, 3000, new String[]{binding.getName()});
            EDTCoreIDEPlugin.getPlugin().log("Part Validation Failure", e);
        }
    }

    private class WorkingCopyDependencyInfo
    extends AbstractDependencyInfo {
        private WorkingCopyDependencyInfo() {
        }

        @Override
        protected void recordQualifiedName(String strings) {
        }

        public Set getQualifiedNames() {
            return Collections.EMPTY_SET;
        }

        public Set getSimpleNames() {
            return Collections.EMPTY_SET;
        }

        public void recordName(Name name) {
        }

        public void recordPackageBinding(IPackageBinding binding) {
        }

        public void recordSimpleName(String simpleName) {
        }

        public void recordType(Type binding) {
        }
    }
}

