/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler.workingcopy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IPartASTRequestor;
import org.eclipse.edt.ide.core.search.ICompiledFileUnit;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;

public class CompiledFileUnit
implements ICompiledFileUnit,
IPartASTRequestor {
    File fileAST = null;
    FileBinding fileBinding = null;
    ArrayList boundPartList = new ArrayList();
    HashMap fileASTs = new HashMap();
    ArrayList asts = new ArrayList();
    HashMap referenceFiles = new HashMap();
    HashMap referencedParts = new HashMap();
    private List<IBinding> bindings = new ArrayList<IBinding>();

    @Override
    public File getFile() {
        return this.fileAST;
    }

    @Override
    public Node[] getAllParts() {
        return this.referencedParts.keySet().toArray(new Node[this.referencedParts.size()]);
    }

    private org.eclipse.edt.compiler.core.ast.Part getPart(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof org.eclipse.edt.compiler.core.ast.Part) {
            return (org.eclipse.edt.compiler.core.ast.Part)node;
        }
        return this.getPart(node.getParent());
    }

    @Override
    public HashMap getReferencedFiles() {
        return this.referenceFiles;
    }

    @Override
    public FileBinding getFileBinding() {
        return this.fileBinding;
    }

    @Override
    public List getFileParts() {
        return this.boundPartList;
    }

    public void setFileAST(File fileAST) {
        this.fileAST = fileAST;
    }

    public void setFileBinding(FileBinding fileBinding) {
        this.fileBinding = fileBinding;
    }

    public void addBoundPart(IFile file, org.eclipse.edt.compiler.core.ast.Part part) {
        this.boundPartList.add(part);
    }

    @Override
    public Node getPartAST(IBinding partBinding) {
        if (partBinding != null) {
            Node part = (Node)this.fileASTs.get(partBinding);
            return part;
        }
        return null;
    }

    @Override
    public void addPartAST(IFile file, Node part) {
        this.asts.add(part);
        this.referenceFiles.put(file, file);
        this.referencedParts.put(part, file);
    }

    public void indexASTs() {
        int i = 0;
        while (i < this.asts.size()) {
            NestedFunction function;
            Type binding;
            Node node = (Node)this.asts.get(i);
            if (node instanceof org.eclipse.edt.compiler.core.ast.Part) {
                org.eclipse.edt.compiler.core.ast.Part part = (org.eclipse.edt.compiler.core.ast.Part)node;
                binding = part.getName().resolveType();
                if (binding != null) {
                    if (binding instanceof Part) {
                        this.fileASTs.put(binding, part);
                    }
                } else {
                    Member m = part.getName().resolveMember();
                    if (m instanceof FunctionMember) {
                        this.fileASTs.put(m, part);
                    }
                }
            } else if (node instanceof NestedFunction && (binding = (function = (NestedFunction)node).getName().resolveMember()) instanceof FunctionMember) {
                this.fileASTs.put(binding, function);
            }
            ++i;
        }
    }

    public void addIBinding(IBinding binding) {
        if (!this.bindings.contains(binding)) {
            this.bindings.add(binding);
        }
    }

    @Override
    public List<IBinding> getIBindingsFromIR() {
        ArrayList<IBinding> temp = new ArrayList<IBinding>(this.bindings);
        return temp;
    }
}

