/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.builder.AbstractPartMarkerProblemRequestor;

public class ContextSpecificMarkerProblemRequestor
extends AbstractPartMarkerProblemRequestor {
    private IPath containerContextPath;
    public static final String CONTEXT_PATH = "contextPath";

    public ContextSpecificMarkerProblemRequestor(IFile file, String functionName, String containerContextName, IPath containerContextFilePath) {
        super(file, functionName, containerContextName);
        this.containerContextPath = containerContextFilePath.append(containerContextName);
        this.removeMarkers();
    }

    @Override
    protected IMarker createMarker(int startOffset, int endOffset, int severity, int problemKind, String[] inserts, ResourceBundle bundle) throws CoreException {
        IMarker marker = super.createMarker(startOffset, endOffset, severity, problemKind, inserts, bundle);
        marker.setAttribute(CONTEXT_PATH, (Object)this.containerContextPath.toOSString());
        return marker;
    }

    @Override
    protected String getMarkerType(int problemKind) {
        return CONTEXT_SPECIFIC_PROBLEM;
    }

    @Override
    protected String[] getMarkerTypes() {
        return new String[]{CONTEXT_SPECIFIC_PROBLEM};
    }

    @Override
    protected boolean shouldRemoveMarker(IMarker marker) {
        Path specifiedProgramPath;
        return super.shouldRemoveMarker(marker) && (specifiedProgramPath = new Path(marker.getAttribute(CONTEXT_PATH, ""))).equals((Object)this.containerContextPath);
    }
}

