/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import com.ibm.icu.text.NumberFormat;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;

public abstract class AbstractMarkerProblemRequestor
extends DefaultProblemRequestor {
    public static final String PROBLEM = String.valueOf(EDTCoreIDEPlugin.PLUGIN_ID) + ".problem";
    public static final String BUILD_PROBLEM = String.valueOf(EDTCoreIDEPlugin.PLUGIN_ID) + ".buildProblem";
    public static final String CONTEXT_SPECIFIC_PROBLEM = String.valueOf(EDTCoreIDEPlugin.PLUGIN_ID) + ".contextSpecificProblem";
    public static final String FILE_PROBLEM = String.valueOf(EDTCoreIDEPlugin.PLUGIN_ID) + ".fileProblem";
    public static final String PARSER_PROBLEM = String.valueOf(EDTCoreIDEPlugin.PLUGIN_ID) + ".syntaxProblem";
    public static final String UNSUPPORTED_SYNTAX_PROBLEM = String.valueOf(EDTCoreIDEPlugin.PLUGIN_ID) + ".unsupportedSyntaxProblem";
    public static final String PART_NAME = "partName";
    public static final String EGL_PROBLEM = "eglProblem";
    protected IFile file;
    private String errorMsgCode;

    public AbstractMarkerProblemRequestor(IFile file, String errorMsgCode) {
        this.file = file;
        this.errorMsgCode = errorMsgCode;
    }

    public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts, ResourceBundle bundle) {
        if (severity == 2) {
            this.setHasError(true);
        }
        try {
            this.createMarker(startOffset, endOffset, severity, problemKind, inserts, bundle);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected IMarker createMarker(int startOffset, int endOffset, int severity, int problemKind, String[] inserts, ResourceBundle bundle) throws CoreException {
        return this.createMarker(startOffset, endOffset, this.getLineNumberOfOffset(startOffset), severity, problemKind, inserts, bundle);
    }

    protected IMarker createMarker(int startOffset, int endOffset, int lineNumber, int severity, int problemKind, String[] inserts, ResourceBundle bundle) throws CoreException {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumIntegerDigits(3);
        IMarker marker = this.file.createMarker(this.getMarkerType(problemKind));
        if (problemKind != -1) {
            marker.setAttribute("message", (Object)this.getErrorMessageText(problemKind, startOffset, lineNumber, severity, AbstractMarkerProblemRequestor.getMessageFromBundle((int)problemKind, (String[])inserts, (ResourceBundle)bundle)));
        } else {
            marker.setAttribute("message", (Object)this.getErrorMessageText(problemKind, startOffset, lineNumber, severity, inserts[0]));
        }
        marker.setAttribute("severity", this.translateSeverity(severity));
        marker.setAttribute("charStart", startOffset);
        marker.setAttribute("charEnd", endOffset);
        marker.setAttribute("lineNumber", lineNumber + 1);
        marker.setAttribute(EGL_PROBLEM, problemKind);
        return marker;
    }

    private int translateSeverity(int severity) {
        switch (severity) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return 2;
    }

    private String getErrorMessageText(int problemKind, int startOffset, int lineNumber, int severity, String msgText) {
        StringBuffer result = new StringBuffer();
        result.append(this.getMessagePrefix(problemKind, startOffset, lineNumber, severity));
        result.append(" ");
        result.append(msgText);
        return result.toString();
    }

    private String getMessagePrefix(int problemKind, int startOffset, int lineNumber, int severity) {
        StringBuffer prefix = new StringBuffer();
        prefix.append("IWN.");
        prefix.append(this.errorMsgCode);
        if (problemKind != -1) {
            prefix.append(".");
            prefix.append(Integer.toString(problemKind));
        }
        if (2 == severity) {
            prefix.append(".e");
        } else if (1 == severity) {
            prefix.append(".w");
        } else if (severity == 0) {
            prefix.append(".i");
        }
        prefix.append(" ");
        prefix.append(Integer.toString(lineNumber + 1));
        prefix.append("/");
        int offsetOnLine = startOffset - this.getLineOffset(lineNumber);
        prefix.append(Integer.toString(offsetOnLine + 1));
        return prefix.toString();
    }

    protected int getLineOffset(int lineNumber) {
        IFileInfo fileInfo = FileInfoManager.getInstance().getFileInfo(this.file.getProject(), this.file.getProjectRelativePath());
        return fileInfo.getOffsetForLine(lineNumber);
    }

    protected int getLineNumberOfOffset(int offset) {
        IFileInfo fileInfo = FileInfoManager.getInstance().getFileInfo(this.file.getProject(), this.file.getProjectRelativePath());
        return fileInfo.getLineNumberForOffset(offset);
    }

    protected abstract String getMarkerType(int var1);

    protected abstract String[] getMarkerTypes();

    protected void removeMarkers() {
        try {
            String[] markerTypes = this.getMarkerTypes();
            int i = 0;
            while (i < markerTypes.length) {
                IMarker[] markers = this.file.findMarkers(markerTypes[i], false, 2);
                int j = 0;
                while (j < markers.length) {
                    IMarker marker = markers[j];
                    if (this.shouldRemoveMarker(marker)) {
                        marker.delete();
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected abstract boolean shouldRemoveMarker(IMarker var1);
}

