/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.compiler.ASTValidator;
import org.eclipse.edt.compiler.BaseCompiler;
import org.eclipse.edt.compiler.ICompilerExtension;
import org.eclipse.edt.compiler.IGenerator;
import org.eclipse.edt.compiler.ZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.egl2mof.ElementGenerator;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.osgi.framework.Bundle;

public class IDEBaseCompiler
implements IIDECompiler {
    protected String systemPath;
    protected BaseCompiler baseCompiler;
    protected String preferencePageId;

    public IDEBaseCompiler() {
        this(new BaseCompiler());
    }

    public IDEBaseCompiler(BaseCompiler baseCompiler) {
        this.baseCompiler = baseCompiler;
    }

    @Override
    public void setPreferencePageId(String id) {
        this.preferencePageId = id;
    }

    @Override
    public String getPreferencePageId() {
        return this.preferencePageId;
    }

    public static String getPathToPluginDirectory(String pluginID, String subDir) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        try {
            String file = FileLocator.resolve((URL)bundle.getEntry("/")).getFile();
            file = file.replace('/', File.separatorChar);
            file = String.valueOf(file) + subDir;
            return file;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public String getId() {
        return this.baseCompiler.getId();
    }

    public void setId(String id) {
        this.baseCompiler.setId(id);
    }

    public String getName() {
        return this.baseCompiler.getName();
    }

    public void setName(String name) {
        this.baseCompiler.setName(name);
    }

    public List<IGenerator> getGenerators() {
        return this.baseCompiler.getGenerators();
    }

    public void addGenerator(IGenerator generator) {
        this.baseCompiler.addGenerator(generator);
    }

    public void setVersion(String version) {
        this.baseCompiler.setVersion(version);
    }

    public String getVersion() {
        return this.baseCompiler.getVersion();
    }

    public String getSystemEnvironmentPath() {
        if (this.systemPath == null) {
            List<String> entries = this.getSystemEnvironmentPathEntries();
            StringBuilder buf = new StringBuilder(200);
            for (String entry : entries) {
                if (entry == null) continue;
                if (buf.length() > 0) {
                    buf.append(File.pathSeparatorChar);
                }
                if ((entry = entry.trim()).length() <= 0) continue;
                buf.append(entry);
            }
            this.systemPath = buf.toString();
        }
        return this.systemPath;
    }

    protected List<String> getSystemEnvironmentPathEntries() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(IDEBaseCompiler.getPathToPluginDirectory("org.eclipse.edt.mof.egl", "lib"));
        for (ICompilerExtension ext : this.baseCompiler.getExtensions()) {
            String[] paths = ext.getSystemEnvironmentPaths();
            if (paths == null || paths.length <= 0) continue;
            int i = 0;
            while (i < paths.length) {
                list.add(paths[i]);
                ++i;
            }
        }
        return list;
    }

    public List<ASTValidator> getValidatorsFor(Node node) {
        return this.baseCompiler.getValidatorsFor(node);
    }

    public ElementGenerator getElementGeneratorFor(Node node) {
        return this.baseCompiler.getElementGeneratorFor(node);
    }

    public List<ICompilerExtension> getExtensions() {
        return this.baseCompiler.getExtensions();
    }

    public void addExtension(ICompilerExtension extension) {
        this.baseCompiler.addExtension(extension);
    }

    public List<ZipFileBindingBuildPathEntry> getSystemBuildPathEntries() {
        return this.baseCompiler.getSystemBuildPathEntries(this.getSystemEnvironmentPath());
    }
}

