/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.ide.rui.document.utils.AssignmentsLocator;
import org.eclipse.edt.ide.rui.document.utils.DocumentUtil;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.utils.NameUtile;

public class GetLayoutPropertiesValuesOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;
    private String layoutPropertyName = "layoutData";
    private Expression layoutData;
    private List assignments;

    public List getAllProperties() {
        return this.assignments;
    }

    public GetLayoutPropertiesValuesOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public void visitProperties(int widgetOffset, int widgetLength) {
        if (widgetOffset <= 0 || widgetLength <= 0) {
            return;
        }
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    Node widgetReference = DocumentUtil.getWidgetNode(this.currentDocument, widgetOffset, widgetLength);
                    if (widgetReference != null) {
                        widgetReference.accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(NewExpression newExpression) {
                                if (newExpression.hasSettingsBlock()) {
                                    AssignmentLocator locator = new AssignmentLocator(NameUtile.getAsName((String)GetLayoutPropertiesValuesOperation.this.layoutPropertyName));
                                    newExpression.getSettingsBlock().accept((IASTVisitor)locator);
                                    if (locator.getAssignment() != null) {
                                        GetLayoutPropertiesValuesOperation.this.layoutData = locator.getAssignment().getRightHandSide();
                                    }
                                }
                                return false;
                            }

                            public boolean visit(SimpleName simpleName) {
                                Node parentNode = simpleName.getParent();
                                if (parentNode != null) {
                                    parentNode.accept((IASTVisitor)new DefaultASTVisitor(){

                                        public boolean visit(ClassDataDeclaration classDataDeclaration) {
                                            if (classDataDeclaration.hasSettingsBlock()) {
                                                AssignmentLocator locator = new AssignmentLocator(NameUtile.getAsName((String)GetLayoutPropertiesValuesOperation.this.layoutPropertyName));
                                                classDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)locator);
                                                if (locator.getAssignment() != null) {
                                                    GetLayoutPropertiesValuesOperation.this.layoutData = locator.getAssignment().getRightHandSide();
                                                }
                                            }
                                            return false;
                                        }
                                    });
                                }
                                return false;
                            }
                        });
                    }
                    if (this.layoutData != null) {
                        this.layoutData.accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(NewExpression newExpression) {
                                GetLayoutPropertiesValuesOperation.this.processNewExpression(newExpression);
                                return false;
                            }

                            public boolean visit(SimpleName simpleName) {
                                Node parentNode = simpleName.getParent();
                                if (parentNode != null) {
                                    parentNode.accept((IASTVisitor)new DefaultASTVisitor(){

                                        public boolean visit(ClassDataDeclaration classDataDeclaration) {
                                            boolean foundSetting = false;
                                            if (classDataDeclaration.hasSettingsBlock()) {
                                                AssignmentsLocator locator = new AssignmentsLocator();
                                                classDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)locator);
                                                GetLayoutPropertiesValuesOperation.this.assignments = locator.getAssignments();
                                            }
                                            if (!foundSetting && classDataDeclaration.hasInitializer()) {
                                                Expression initializer = classDataDeclaration.getInitializer();
                                                initializer.accept((IASTVisitor)new DefaultASTVisitor(){

                                                    public boolean visit(NewExpression newExpression) {
                                                        GetLayoutPropertiesValuesOperation.this.processNewExpression(newExpression);
                                                        return false;
                                                    }
                                                });
                                            }
                                            return false;
                                        }

                                        public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                                            boolean foundSetting = false;
                                            if (functionDataDeclaration.hasSettingsBlock()) {
                                                AssignmentsLocator locator = new AssignmentsLocator();
                                                functionDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)locator);
                                                GetLayoutPropertiesValuesOperation.this.assignments = locator.getAssignments();
                                            }
                                            if (!foundSetting && functionDataDeclaration.hasInitializer()) {
                                                Expression initializer = functionDataDeclaration.getInitializer();
                                                initializer.accept((IASTVisitor)new DefaultASTVisitor(){

                                                    public boolean visit(NewExpression newExpression) {
                                                        GetLayoutPropertiesValuesOperation.this.processNewExpression(newExpression);
                                                        return false;
                                                    }
                                                });
                                            }
                                            return false;
                                        }
                                    });
                                }
                                return false;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Property Value: Error accessing property value", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Property Value: Error creating working copy", (Throwable)e));
        }
    }

    private void processNewExpression(NewExpression newExpression) {
        if (newExpression.hasSettingsBlock()) {
            AssignmentsLocator locator = new AssignmentsLocator();
            newExpression.getSettingsBlock().accept((IASTVisitor)locator);
            this.assignments = locator.getAssignments();
        }
    }
}

