/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.DocumentUtil;
import org.eclipse.edt.ide.rui.document.utils.EGLContainerDeleteStrategy;
import org.eclipse.edt.ide.rui.document.utils.EGLRUIHandlerDeleteStrategy;
import org.eclipse.edt.ide.rui.document.utils.EGLRUIWidgetDeleteStrategy;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.utils.NameUtile;

public class DeleteWidgetReferenceOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;
    private int numCharactersRemoved = 0;
    private String deletedChildName;

    public DeleteWidgetReferenceOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public int deleteWidgetReference(int containerOffset, int containerLength, final int containerIndex) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    final Node container = DocumentUtil.getWidgetNode(this.currentDocument, containerOffset, containerLength);
                    container.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(Handler handler) {
                            String typeName = NameUtile.getAsName((String)new String(handler.getSubType().getCanonicalName()));
                            if (NameUtile.equals((String)typeName, (String)Util.RUIHANDLER)) {
                                EGLRUIHandlerDeleteStrategy strategy = new EGLRUIHandlerDeleteStrategy(handler, DeleteWidgetReferenceOperation.this.currentDocument);
                                DeleteWidgetReferenceOperation.this.numCharactersRemoved = strategy.deleteFromHandler(containerIndex);
                                DeleteWidgetReferenceOperation.this.deletedChildName = strategy.getDeletedWidgetName();
                            } else if (NameUtile.equals((String)typeName, (String)Util.RUIWIDGET)) {
                                EGLRUIWidgetDeleteStrategy strategy = new EGLRUIWidgetDeleteStrategy(handler, DeleteWidgetReferenceOperation.this.currentDocument);
                                strategy.deleteTargetWidget();
                                DeleteWidgetReferenceOperation.this.deletedChildName = strategy.getDeletedWidgetName();
                            }
                            return false;
                        }

                        public boolean visit(NewExpression newExpression) {
                            EGLContainerDeleteStrategy strategy = new EGLContainerDeleteStrategy(container, DeleteWidgetReferenceOperation.this.currentDocument);
                            DeleteWidgetReferenceOperation.this.numCharactersRemoved = strategy.deleteFromContainer(containerIndex);
                            DeleteWidgetReferenceOperation.this.deletedChildName = strategy.getDeletedWidgetName();
                            return false;
                        }

                        public boolean visit(SimpleName simpleName) {
                            EGLContainerDeleteStrategy strategy = new EGLContainerDeleteStrategy(container, DeleteWidgetReferenceOperation.this.currentDocument);
                            DeleteWidgetReferenceOperation.this.numCharactersRemoved = strategy.deleteFromContainer(containerIndex);
                            DeleteWidgetReferenceOperation.this.deletedChildName = strategy.getDeletedWidgetName();
                            return false;
                        }
                    });
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Delete Widget Reference: Error deleting reference", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Delete Widget Reference: Error creating working copy", (Throwable)e));
        }
        return this.numCharactersRemoved;
    }

    public String getDeletedWidgetName() {
        return this.deletedChildName;
    }
}

