/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;

public class AddImportOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;

    public AddImportOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public void addFullyQualifiedImport(String importName) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    File fileAST = this.currentDocument.getNewModelEGLFile();
                    this.addImport(importName, fileAST);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addImport(String importName, File fileAST) throws EGLModelException, MalformedTreeException, BadLocationException {
        ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
        rewrite.addImport(fileAST, importName, false);
        rewrite.rewriteAST((IDocument)this.currentDocument).apply((IDocument)this.currentDocument);
    }
}

