/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.actions;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.rui.internal.nls.RUINlsStrings;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class ActionLaunchExternalBrowser
extends Action {
    protected String _strUrl = null;
    protected boolean _isDebug;

    public ActionLaunchExternalBrowser(String strUrl, boolean isDebug) {
        super("");
        this._strUrl = strUrl.replaceAll(" ", "%20");
        this._isDebug = isDebug;
    }

    public void run() {
        boolean launched;
        if (this._strUrl == null || this._strUrl.length() == 0) {
            if (this._isDebug) {
                throw new RuntimeException(RUINlsStrings.NoPreviewContent_Msg);
            }
            MessageDialog.openInformation((Shell)Util.getShell(), (String)RUINlsStrings.NoPreviewContent_Title, (String)RUINlsStrings.NoPreviewContent_Msg);
            return;
        }
        try {
            IWebBrowser browser = WorkbenchBrowserSupport.getInstance().getExternalBrowser();
            if (browser != null) {
                browser.openURL(new URL(this._strUrl));
                launched = true;
            } else {
                launched = this.launchSystemBrowser(this._strUrl);
            }
        }
        catch (Exception exception) {
            launched = this.launchSystemBrowser(this._strUrl);
        }
        if (!launched) {
            if (this._isDebug) {
                throw new RuntimeException(RUINlsStrings.NoBrowserDialog_Msg);
            }
            ErrorDialog.openError(null, (String)RUINlsStrings.NoBrowserDialog_Title, (String)RUINlsStrings.NoBrowserDialog_Msg, (IStatus)new Status(4, "org.eclipse.edt.ide.rui", RUINlsStrings.NoBrowserDialog_Msg));
        }
    }

    private boolean launchSystemBrowser(final String url) {
        if (this._isDebug) {
            final boolean[] launched = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    launched[0] = Program.launch((String)url);
                }
            });
            return launched[0];
        }
        return Program.launch((String)url);
    }
}

