/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.generator.example.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.generator.example.EGL2Example;
import org.eclipse.edt.ide.compiler.gen.EclipseGeneratorUtility;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.LoadPartException;

public class EclipseExampleGenerator
extends EGL2Example {
    private final IFile eglFile;
    private final Part part;
    private final IGenerator generatorProvider;

    public EclipseExampleGenerator(IFile eglFile, Part part, IGenerator generator) {
        this.eglFile = eglFile;
        this.part = part;
        this.generatorProvider = generator;
    }

    protected List<Part> loadEGLParts(ICompiler compiler) throws LoadPartException {
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.part);
        return parts;
    }

    protected void writeFile(Part part, Generator generator) throws Exception {
        String outputFolder = (String)((CommandParameter)this.getParameterMapping().get("output")).getValue();
        if (EclipseUtilities.shouldWriteFileInEclipse((String)outputFolder)) {
            EclipseGeneratorUtility.writeAndProcessJavaFile((String)outputFolder, (Part)part, (Generator)generator, (IGenerator)this.generatorProvider, (IFile)this.eglFile);
        } else {
            super.writeFile(part, generator);
        }
    }

    protected void writeSMAPFile(byte[] data, Part part, Generator generator) throws Exception {
        String outputFolder = (String)((CommandParameter)this.getParameterMapping().get("output")).getValue();
        if (EclipseUtilities.shouldWriteFileInEclipse((String)outputFolder)) {
            EclipseGeneratorUtility.writeSMAPFile((byte[])data, (String)outputFolder, (Part)part, (Generator)generator, (IFile)this.eglFile);
        } else {
            super.writeSMAPFile(data, part, generator);
        }
    }
}

