/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.results;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.results.views.AbstractResultsListViewerAction;
import org.eclipse.edt.ide.ui.internal.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class EGLDeployResultsView
extends ViewPart {
    LinkedHashMap results = new LinkedHashMap();
    ImageDescriptorRegistry fRegistry = null;
    private EGLUtilitiesDeployResultsListViewerAction selectAllAction = null;
    private EGLUtilitiesDeployResultsListViewerAction deselectAllAction = null;
    private EGLUtilitiesDeployResultsListViewerAction copyAction = null;
    private EGLRemoveTabAction removeTabAction = null;
    private EGLRemoveAllTabsAction removeAllTabsAction = null;
    private EGLRemoveTabsWithNoErrorsAction removeTabsWithNoErrorsAction = null;
    public static final int VIEW_FLAT = 0;
    public static final int VIEW_VERTICAL = 0;
    public static final int VIEW_HORIZONTAL = 1;
    public static final int VIEW_AUTOMATIC = 3;
    int fOrientation = 3;
    boolean fInComputeOrientation = false;
    private TableViewer fLhsViewer;
    private ListViewer fResultsViewer;
    private SashForm fResultsSplitter;
    private PageBook fPagebook;
    private Label fNoHierarchyShownLabel;
    private ViewForm fLhsViewerViewForm;
    private ViewForm fResultViewerViewForm;
    private Composite fParent;

    private List addCollector(IDeploymentResultsCollector collector) {
        this.removeExisitngCollectorWithSameName(collector);
        ArrayList list = new ArrayList();
        this.results.put(collector, list);
        this.fLhsViewer.setInput((Object)this);
        if (this.fLhsViewer.getSelection() == null || this.fLhsViewer.getSelection().isEmpty()) {
            this.fLhsViewer.setSelection((ISelection)new StructuredSelection((Object)collector), true);
            this.doLhsSelectionChanged(this.fLhsViewer.getSelection());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultsUpdate(IDeploymentResultsCollector collector, IStatus status) {
        LinkedHashMap linkedHashMap = this.results;
        synchronized (linkedHashMap) {
            this.addResult(collector, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(IDeploymentResultsCollector collector) {
        LinkedHashMap linkedHashMap = this.results;
        synchronized (linkedHashMap) {
            if (!this.fPagebook.isDisposed()) {
                List list = (List)this.results.get(collector);
                if (list != null && list.size() > 0) {
                    this.markTitleTabChanged();
                }
                this.fPagebook.showPage((Control)this.fResultsSplitter);
                this.fLhsViewer.setInput((Object)this);
            }
        }
    }

    private void markTitleTabChanged() {
        Object siteService = this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)siteService;
            service.warnOfContentChange();
        }
    }

    private void addResult(IDeploymentResultsCollector collector, IStatus status) {
        if (!this.fPagebook.isDisposed()) {
            this.fPagebook.showPage((Control)this.fResultsSplitter);
            List list = (List)this.results.get(collector);
            if (list == null) {
                list = this.addCollector(collector);
            }
            list.add(status);
            this.fLhsViewer.setInput((Object)this);
            this.setSelectionIfNecessary(collector);
            this.markTitleTabChanged();
        }
    }

    private void setSelectionIfNecessary(IDeploymentResultsCollector coll) {
        ISelection sel = this.fLhsViewer.getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty() && ((IStructuredSelection)sel).getFirstElement() == coll) {
            this.doLhsSelectionChanged(this.fLhsViewer.getSelection());
        }
    }

    private void removeExisitngCollectorWithSameName(IDeploymentResultsCollector collector) {
        String name = collector.getName();
        Iterator i = this.results.keySet().iterator();
        IDeploymentResultsCollector coll = null;
        while (i.hasNext() && coll == null) {
            IDeploymentResultsCollector next = (IDeploymentResultsCollector)i.next();
            if (!next.getName().equals(name)) continue;
            coll = next;
        }
        if (coll != null) {
            this.results.remove(coll);
        }
    }

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = EDTUIPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private Control createLhsViewerControl(Composite parent) {
        this.fLhsViewer = new TableViewer(parent);
        this.initializeLhsViewer();
        this.fLhsViewer.setInput((Object)this);
        return this.fLhsViewer.getControl();
    }

    private void initializeLhsViewer() {
        this.fLhsViewer.getControl().setVisible(true);
        this.fLhsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Set c = EGLDeployResultsView.this.results.keySet();
                if (c.isEmpty()) {
                    EGLDeployResultsView.this.fPagebook.showPage((Control)EGLDeployResultsView.this.fNoHierarchyShownLabel);
                }
                return c.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fLhsViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                if (element instanceof IDeploymentResultsCollector) {
                    IDeploymentResultsCollector coll = (IDeploymentResultsCollector)element;
                    if (coll.isDone()) {
                        if (coll.hasError()) {
                            return EGLDeployResultsView.this.getRegistry().get(PluginImages.DESC_OBJS_GEN_FAIL);
                        }
                        if (coll.hasWarning()) {
                            return EGLDeployResultsView.this.getRegistry().get(PluginImages.DESC_OBJS_GEN_WARNING);
                        }
                        return EGLDeployResultsView.this.getRegistry().get(PluginImages.DESC_OBJS_GEN_SUCCESS);
                    }
                    return EGLDeployResultsView.this.getRegistry().get(PluginImages.DESC_OBJS_GEN_RUN);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IDeploymentResultsCollector) {
                    IDeploymentResultsCollector coll = (IDeploymentResultsCollector)element;
                    return coll.getName();
                }
                return "ERROR";
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
        this.fLhsViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EGLDeployResultsView.this.doLhsSelectionChanged(event);
            }
        });
        this.fLhsViewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof IDeploymentResultsCollector) {
                    IDeploymentResultsCollector coll = (IDeploymentResultsCollector)element;
                    if (coll.hasError()) {
                        return 0;
                    }
                    if (coll.hasWarning()) {
                        return 1;
                    }
                    return 2;
                }
                return super.category(element);
            }
        });
    }

    private Control createResultViewerControl(Composite parent) {
        this.fResultsViewer = new ListViewer(parent);
        this.fResultsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List list = (List)EGLDeployResultsView.this.results.get(inputElement);
                if (list != null) {
                    return list.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fResultsViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof IStatus) {
                    String prefix = "";
                    IStatus status = (IStatus)element;
                    switch (status.getSeverity()) {
                        case 8: {
                            prefix = "Cancled: ";
                            break;
                        }
                        case 4: {
                            prefix = "Error: ";
                            break;
                        }
                        case 1: {
                            prefix = "Info: ";
                            break;
                        }
                        case 2: {
                            prefix = "Warning: ";
                            break;
                        }
                        case 0: {
                            prefix = "Success: ";
                        }
                    }
                    return String.valueOf(prefix) + status.getMessage();
                }
                return "";
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
        this.fResultsViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.fResultsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        org.eclipse.swt.widgets.List control = this.fResultsViewer.getList();
        return control;
    }

    public void createPartControl(Composite container) {
        this.fParent = container;
        this.addResizeListener(container);
        this.fPagebook = new PageBook(container, 0);
        this.fNoHierarchyShownLabel = new Label((Composite)this.fPagebook, 16576);
        this.fNoHierarchyShownLabel.setText(UINlsStrings.GRVNOResultsText);
        this.fResultsSplitter = new SashForm((Composite)this.fPagebook, 512);
        this.fResultsSplitter.setVisible(false);
        this.fLhsViewerViewForm = new ViewForm((Composite)this.fResultsSplitter, 0);
        Control partsViewerControl = this.createLhsViewerControl((Composite)this.fLhsViewerViewForm);
        this.fLhsViewerViewForm.setContent(partsViewerControl);
        this.fResultViewerViewForm = new ViewForm((Composite)this.fResultsSplitter, 0);
        this.fResultsSplitter.setWeights(new int[]{35, 65});
        Control resultsViewerPart = this.createResultViewerControl((Composite)this.fResultViewerViewForm);
        this.fResultViewerViewForm.setContent(resultsViewerPart);
        this.createActions();
        this.registerActions();
        this.createPartsContextMenu();
        this.createResultsContextMenu();
        this.fPagebook.showPage((Control)this.fNoHierarchyShownLabel);
        this.computeOrientation();
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                EGLDeployResultsView.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        if (this.fInComputeOrientation) {
            return;
        }
        this.fInComputeOrientation = true;
        try {
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
        finally {
            this.fInComputeOrientation = false;
        }
    }

    public void setOrientation(int orientation) {
        if (this.fResultViewerViewForm != null && !this.fResultViewerViewForm.isDisposed() && this.fResultsSplitter != null && !this.fResultsSplitter.isDisposed()) {
            this.fResultsSplitter.setOrientation(orientation == 1 ? 256 : 512);
            this.fResultsSplitter.layout();
        }
    }

    protected void doLhsSelectionChanged(ISelection s) {
        if (s instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)s;
            Object sel = selection.getFirstElement();
            this.fResultsViewer.setInput(sel);
        }
    }

    protected void doLhsSelectionChanged(SelectionChangedEvent e) {
        if (e.getSelection() != null && !e.getSelection().isEmpty()) {
            this.doLhsSelectionChanged(e.getSelection());
        }
    }

    private void createResultsContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EGLDeployResultsView.this.fillResultsContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.fResultsViewer.getList());
        this.fResultsViewer.getList().setMenu(menu);
    }

    private void fillResultsContextMenu(IMenuManager manager) {
        this.selectAllAction.setEnabled(this.fResultsViewer.getList().getSelectionCount() < this.fResultsViewer.getList().getItemCount());
        this.deselectAllAction.setEnabled(this.fResultsViewer.getList().getSelectionCount() > 0);
        this.copyAction.setEnabled(this.fResultsViewer.getList().getSelectionCount() > 0);
        manager.add((IAction)this.selectAllAction);
        manager.add((IAction)this.deselectAllAction);
        manager.add((IAction)this.copyAction);
    }

    private void createPartsContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EGLDeployResultsView.this.fillLhsContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fLhsViewer.getControl());
        this.fLhsViewer.getControl().setMenu(menu);
    }

    private void fillLhsContextMenu(IMenuManager manager) {
        manager.add((IAction)this.removeTabAction);
        manager.add((IAction)this.removeAllTabsAction);
        manager.add((IAction)this.removeTabsWithNoErrorsAction);
    }

    public void createActions() {
        this.selectAllAction = new EGLUtilitiesDeployResultsListViewerAction(UINlsStrings.SelectAllLabel, this, 1);
        this.deselectAllAction = new EGLUtilitiesDeployResultsListViewerAction(UINlsStrings.DeselectAllLabel, this, 2);
        this.deselectAllAction.setEnabled(false);
        this.copyAction = new EGLUtilitiesDeployResultsListViewerAction(UINlsStrings.CopyLabel, this, 3);
        this.copyAction.setEnabled(false);
    }

    public void removeAllEntry() {
        this.results.clear();
        this.fLhsViewer.setInput((Object)this);
    }

    public void removeEntry() {
        ISelection cSelection = this.fLhsViewer.getSelection();
        if (cSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)cSelection;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                this.results.remove(iter.next());
            }
            this.fLhsViewer.setInput((Object)this);
        }
    }

    public void removeEntryWithNoErrors() {
        Iterator iter = this.results.keySet().iterator();
        while (iter.hasNext()) {
            IDeploymentResultsCollector coll = (IDeploymentResultsCollector)iter.next();
            if (coll.hasError()) continue;
            iter.remove();
        }
        this.fLhsViewer.setInput((Object)this);
    }

    protected void registerActions() {
        this.removeTabAction = new EGLRemoveTabAction(UINlsStrings.GRVRemoveEntryText);
        this.removeAllTabsAction = new EGLRemoveAllTabsAction(UINlsStrings.GRVRemoveAllEntryText);
        this.removeTabsWithNoErrorsAction = new EGLRemoveTabsWithNoErrorsAction(UINlsStrings.GRVRemoveEntryWithNoErrorsText);
    }

    public class EGLRemoveAllTabsAction
    extends Action {
        public EGLRemoveAllTabsAction(String title) {
            super(title);
        }

        public void run() {
            EGLDeployResultsView.this.removeAllEntry();
        }
    }

    public class EGLRemoveTabAction
    extends Action {
        public EGLRemoveTabAction(String title) {
            super(title);
        }

        public void run() {
            EGLDeployResultsView.this.removeEntry();
        }
    }

    public class EGLRemoveTabsWithNoErrorsAction
    extends Action {
        public EGLRemoveTabsWithNoErrorsAction(String title) {
            super(title);
        }

        public void run() {
            EGLDeployResultsView.this.removeEntryWithNoErrors();
        }
    }

    public class EGLUtilitiesDeployResultsListViewerAction
    extends AbstractResultsListViewerAction {
        int actionType;

        protected EGLUtilitiesDeployResultsListViewerAction(String text) {
            super(text);
            this.actionType = 1;
        }

        public EGLUtilitiesDeployResultsListViewerAction(String text, EGLDeployResultsView viewPart, int type) {
            super(text, (ViewPart)viewPart, type);
            this.actionType = 1;
            this.actionType = type;
        }

        public ListViewer getCurrentViewer() {
            return EGLDeployResultsView.this.fResultsViewer;
        }

        public void run() {
            if (this.getCurrentViewer() == null) {
                return;
            }
            switch (this.actionType) {
                case 1: {
                    this.getCurrentViewer().getList().selectAll();
                    break;
                }
                default: {
                    super.run();
                }
            }
        }
    }
}

