/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.declaration.Constraint;
import org.eclipse.emf.edapt.declaration.DeclarationFactory;
import org.eclipse.emf.edapt.declaration.Operation;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.declaration.Parameter;
import org.eclipse.emf.edapt.internal.common.IExtentProvider;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.internal.common.TypeUtils;
import org.eclipse.emf.edapt.internal.declaration.OperationRegistry;
import org.eclipse.emf.edapt.internal.migration.execution.internal.OperationInstanceConverter;
import org.eclipse.emf.edapt.spi.history.HistoryFactory;
import org.eclipse.emf.edapt.spi.history.OperationInstance;
import org.eclipse.emf.edapt.spi.history.ParameterInstance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Repository;

public class OperationInstanceHelper {
    private final IExtentProvider provider;

    public OperationInstanceHelper(IExtentProvider provider) {
        this.provider = provider;
    }

    public List<OperationInstance> getPossibleOperations(List<EObject> selectedElements) {
        ArrayList<OperationInstance> result = new ArrayList<OperationInstance>();
        Collection operations = OperationRegistry.getInstance().getOperations();
        for (Operation operation : operations) {
            OperationInstance operationInstance;
            Parameter mainParameter;
            if (operation.refines() || (mainParameter = operation.getMainParameter()) == null) continue;
            EClass type = (EClass)mainParameter.getClassifier();
            if (!TypeUtils.ancestor((EClass)TypeUtils.commonSuperClass(selectedElements), (EClass)type)) continue;
            if (selectedElements.size() > 1) {
                if (!mainParameter.isMany() || !this.isApplicable(operationInstance = this.createOperationInstance(operation, selectedElements))) continue;
                result.add(operationInstance);
                continue;
            }
            operationInstance = this.createOperationInstance(operation, selectedElements);
            if (!this.isApplicable(operationInstance)) continue;
            result.add(operationInstance);
        }
        return result;
    }

    private boolean isApplicable(OperationInstance operationInstance) {
        Repository repository = OperationInstanceConverter.createEmptyRepository((MetamodelExtent)this.getExtent());
        OperationImplementation operationBase = OperationInstanceConverter.convert((OperationInstance)operationInstance, (Metamodel)repository.getMetamodel());
        List messages = operationBase.checkRestriction(operationInstance.getOperation().getMainParameter().getName(), repository.getMetamodel());
        OperationInstanceConverter.convert((OperationImplementation)operationBase, (OperationInstance)operationInstance);
        return messages.isEmpty();
    }

    public OperationInstance createOperationInstance(Operation operation, List<EObject> selectedElements) {
        HistoryFactory factory = HistoryFactory.eINSTANCE;
        OperationInstance operationInstance = factory.createOperationInstance();
        operationInstance.setName(operation.getName());
        for (Parameter parameter : operation.getParameters()) {
            ParameterInstance parameterInstance = factory.createParameterInstance();
            parameterInstance.setName(parameter.getName());
            operationInstance.getParameters().add((Object)parameterInstance);
            if (!parameter.isMain()) continue;
            if (parameter.isMany()) {
                parameterInstance.setValue(selectedElements);
                continue;
            }
            parameterInstance.setValue((Object)selectedElements.get(0));
        }
        return operationInstance;
    }

    public List<Constraint> getViolatedConstraints(OperationInstance operationInstance) {
        Repository repository = OperationInstanceConverter.createEmptyRepository((MetamodelExtent)this.getExtent());
        OperationImplementation operationBase = OperationInstanceConverter.convert((OperationInstance)operationInstance, (Metamodel)repository.getMetamodel());
        List messages = operationBase.checkPreconditions(repository.getMetamodel());
        ArrayList<Constraint> violatedConstraints = new ArrayList<Constraint>();
        for (String message : messages) {
            Constraint constraint = this.getConstraint(operationInstance.getOperation(), message);
            if (constraint == null) {
                constraint = DeclarationFactory.eINSTANCE.createConstraint();
                constraint.setDescription(message);
            }
            violatedConstraints.add(constraint);
        }
        OperationInstanceConverter.convert((OperationImplementation)operationBase, (OperationInstance)operationInstance);
        return violatedConstraints;
    }

    private Constraint getConstraint(Operation operation, String message) {
        for (Constraint constraint : operation.getConstraints()) {
            if (!message.equals(constraint.getDescription())) continue;
            return constraint;
        }
        return null;
    }

    public MetamodelExtent getExtent() {
        return this.provider.getExtent();
    }
}

