/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="changeAttributeType", label="Change Attribute Type", description="In the metamodel, the type of an attribute is changed. In the model, the values are migrated based on EMF's default serialization.")
public class ChangeAttributeType
extends OperationImplementation {
    @EdaptParameter(main=true, description="The attribute whose type is changed")
    public EAttribute attribute;
    @EdaptParameter(description="The new type of the attribute")
    public EDataType type;

    public void execute(Metamodel metamodel, Model model) {
        EClass eClass = this.attribute.getEContainingClass();
        this.attribute.setEType((EClassifier)this.type);
        for (Instance instance : model.getAllInstances(eClass)) {
            Object newValue;
            if (!instance.isSet((EStructuralFeature)this.attribute)) continue;
            Object value = instance.get((EStructuralFeature)this.attribute);
            if (this.attribute.isMany()) {
                newValue = new ArrayList();
                for (Object v : (List)value) {
                    Object nv = this.convert(v);
                    newValue.add(nv);
                }
                instance.set((EStructuralFeature)this.attribute, newValue);
                continue;
            }
            newValue = this.convert(value);
            instance.set((EStructuralFeature)this.attribute, newValue);
        }
    }

    private Object convert(Object v) {
        EDataType oldType = this.attribute.getEAttributeType();
        String stringValue = EcoreUtil.convertToString((EDataType)oldType, (Object)v);
        Object nv = EcoreUtil.createFromString((EDataType)this.type, (String)stringValue);
        return nv;
    }
}

