/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.declaration;

import java.util.List;
import org.eclipse.emf.edapt.declaration.DeclarationFactory;
import org.eclipse.emf.edapt.declaration.EdaptLibrary;
import org.eclipse.emf.edapt.declaration.Library;
import org.eclipse.emf.edapt.declaration.LibraryImplementation;
import org.eclipse.emf.edapt.declaration.Operation;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.declaration.OperationExtractor;

public class LibraryExtractor {
    public Library extractLibrary(Class<? extends LibraryImplementation> c) {
        EdaptLibrary libraryAnnotation = c.getAnnotation(EdaptLibrary.class);
        if (libraryAnnotation != null) {
            Library library = DeclarationFactory.eINSTANCE.createLibrary();
            library.setName(c.getName());
            library.setImplementation(c);
            library.setLabel(libraryAnnotation.label());
            library.setDescription(libraryAnnotation.description());
            try {
                this.extractChildren(c, library);
                return library;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    private void extractChildren(Class<? extends LibraryImplementation> c, Library library) throws InstantiationException, IllegalAccessException {
        LibraryImplementation libraryImplementation = c.newInstance();
        List<Class<? extends LibraryImplementation>> libraryClasses = libraryImplementation.getLibraries();
        for (Class<? extends LibraryImplementation> libraryClass : libraryClasses) {
            Library subLibrary = this.extractLibrary(libraryClass);
            if (subLibrary == null) continue;
            library.getLibraries().add((Object)subLibrary);
        }
        List<Class<? extends OperationImplementation>> operationClasses = libraryImplementation.getOperations();
        for (Class<? extends OperationImplementation> operationClass : operationClasses) {
            Operation operation = this.extractOperation(operationClass);
            if (operation == null) continue;
            library.getOperations().add((Object)operation);
        }
    }

    private Operation extractOperation(Class<? extends OperationImplementation> c) {
        return new OperationExtractor().extractOperation(c);
    }
}

