/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.releng.p2.to.maven;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.scada.releng.p2.to.maven.Activator;
import org.eclipse.scada.releng.p2.to.maven.DefaultMavenMapping;
import org.eclipse.scada.releng.p2.to.maven.License;
import org.eclipse.scada.releng.p2.to.maven.LicenseProvider;
import org.eclipse.scada.releng.p2.to.maven.MavenDependency;
import org.eclipse.scada.releng.p2.to.maven.MavenMapping;
import org.eclipse.scada.releng.p2.to.maven.MavenReference;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Processor
implements AutoCloseable {
    private static final SimpleDateFormat META_DF = new SimpleDateFormat("yyyyMMddHHmmss");
    private final boolean scrubJars;
    private final boolean dryRun = Boolean.getBoolean("dryRun");
    private final boolean fakeForCentral = Boolean.getBoolean("fakeForCentral");
    private final IProvisioningAgent agent;
    private final File output;
    private final MavenMapping mapping;
    private final URI repositoryLocation;
    private final Properties properties;
    private final DocumentBuilderFactory documentBuilderFactor;
    private final DocumentBuilder documentBuilder;
    private final TransformerFactory transformerFactory;
    private IMetadataRepository metaRepo;
    private IArtifactRepository artRepo;
    private final IMetadataRepositoryManager metaManager;
    private final IArtifactRepositoryManager artManager;
    private final Set<URI> validationRepositoryUris = new HashSet<URI>();
    private final Map<URI, IMetadataRepository> validationRepositories = new HashMap<URI, IMetadataRepository>();
    private final Map<MavenReference, Set<String>> metadata = new HashMap<MavenReference, Set<String>>();
    private final List<Developer> developers = new LinkedList<Developer>();
    private final Set<MavenDependency> mavenDependencies = new HashSet<MavenDependency>();
    private final Set<MavenReference> mavenExports = new HashSet<MavenReference>();
    private final List<String> errors = new LinkedList<String>();
    private Path tmpBndTools;
    private final String organizationName;
    private final String organizationUrl;
    private final LicenseProvider licenseProvider;

    public Processor(IProvisioningAgent agent, File output, URI repositoryLocation, Properties properties) throws Exception {
        this.mapping = Processor.makeMappingInstance(properties);
        this.agent = agent;
        this.output = output;
        this.properties = properties;
        this.repositoryLocation = repositoryLocation;
        this.metaManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        this.artManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        this.documentBuilderFactor = DocumentBuilderFactory.newInstance();
        this.documentBuilder = this.documentBuilderFactor.newDocumentBuilder();
        this.transformerFactory = TransformerFactory.newInstance();
        this.organizationName = properties.getProperty("pom.origanization.name", "Eclipse Foundation");
        this.organizationUrl = properties.getProperty("pom.origanization.url", "http://www.eclipse.org/");
        this.licenseProvider = new LicenseProvider(this.properties);
        this.scrubJars = Boolean.parseBoolean(properties.getProperty("scrubJars"));
        this.loadDevelopers();
        this.setupBndTools();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupBndTools() throws IOException {
        URL url;
        block13: {
            this.tmpBndTools = Files.createTempFile("bndtools-", ".jar", new FileAttribute[0]);
            url = new URL("http://repo1.maven.org/maven2/biz/aQute/bnd/biz.aQute.bnd/3.3.0/biz.aQute.bnd-3.3.0.jar");
            System.out.format("Loading: %s...%n", url);
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                InputStream in = this.openConnection(url).getInputStream();
                try {
                    try (OutputStream out = Files.newOutputStream(this.tmpBndTools, new OpenOption[0]);){
                        ByteStreams.copy((InputStream)in, (OutputStream)out);
                    }
                    if (in == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        System.out.format("Loading: %s... done!%n", url);
    }

    @Override
    public void close() throws Exception {
        Files.deleteIfExists(this.tmpBndTools);
    }

    private void loadDevelopers() {
        String devs = this.properties.getProperty("developers");
        if (devs == null) {
            return;
        }
        String[] stringArray = devs.split("\\s*,+\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dev = stringArray[n2];
            this.developers.add(this.loadDeveloper(dev));
            ++n2;
        }
    }

    private Developer loadDeveloper(String dev) {
        Developer result = new Developer();
        result.id = dev;
        result.name = this.properties.getProperty(String.format("developer.%s.name", dev));
        result.email = this.properties.getProperty(String.format("developer.%s.email", dev));
        result.url = this.properties.getProperty(String.format("developer.%s.url", dev));
        result.organization = this.properties.getProperty(String.format("developer.%s.organization", dev));
        result.organizationUrl = this.properties.getProperty(String.format("developer.%s.organizationUrl", dev));
        return result;
    }

    private static MavenMapping makeMappingInstance(Properties properties) throws Exception {
        String clazzName = properties.getProperty("implementation.mavenMapping", DefaultMavenMapping.class.getName());
        if (clazzName == null || clazzName.isEmpty()) {
            return new DefaultMavenMapping(properties);
        }
        BundleContext context = Activator.getDefault().getContext();
        Class clazz = context.getBundle().loadClass(clazzName);
        Constructor ctor = clazz.getConstructor(Properties.class);
        return (MavenMapping)MavenMapping.class.cast(ctor.newInstance(properties));
    }

    public void addValidationRepository(URI uri) {
        this.validationRepositoryUris.add(uri);
    }

    public void process(IProgressMonitor pm) throws Exception {
        this.output.mkdirs();
        System.out.println("Loading metadata...");
        this.metaRepo = this.metaManager.loadRepository(this.repositoryLocation, pm);
        System.out.println("Loading artifacts...");
        this.artRepo = this.artManager.loadRepository(this.repositoryLocation, pm);
        System.out.println("done!");
        for (URI uri : this.validationRepositoryUris) {
            System.out.format("Loading validation repository: %s%n", uri);
            IMetadataRepository repo = this.metaManager.loadRepository(uri, pm);
            this.validationRepositories.put(uri, repo);
            System.out.println("Done!");
        }
        IQuery query = QueryUtil.createIUAnyQuery();
        IQueryResult result = this.metaRepo.query(query, pm);
        for (IInstallableUnit iu : result) {
            this.processUnit(iu, pm);
        }
        this.writeUploadScript();
        for (Map.Entry<MavenReference, Set<String>> entry : this.metadata.entrySet()) {
            this.writeMetaData(entry.getKey(), entry.getValue());
        }
    }

    private void writeUploadScript() throws Exception {
        List<MavenReference> exports = this.getMavenExports();
        Collections.sort(exports, MavenReference.COMPARATOR);
        HashSet<MavenReference> skips = new HashSet<MavenReference>();
        for (MavenReference export : exports) {
            if (export.getClassifier() != null || this.shouldUpload(export)) continue;
            skips.add(export);
        }
        Path path = this.output.toPath().resolve("upload.sh");
        int maxJobs = Integer.getInteger("maxUploadJobs", 1);
        Throwable throwable = null;
        Object var6_8 = null;
        try (PrintWriter script = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            script.println("#!/bin/bash");
            script.println();
            script.println("set -e");
            script.println();
            script.println("REPO=${REPO:-https://oss.sonatype.org/service/local/staging/deploy/maven2/}");
            script.println("ID=${ID:-ossrh}");
            script.println("MVN=${MVN:-mvn}");
            script.println();
            if (maxJobs > 1) {
                script.format("function waitMax { while [ $(jobs -rp | wc -l) -ge %s ] ; do sleep 1; done }%n%n", maxJobs);
            }
            for (MavenReference export : exports) {
                if (skips.contains(new MavenReference(export.getGroupId(), export.getArtifactId(), export.getVersion()))) {
                    script.println("# skipping - " + export);
                    continue;
                }
                if (maxJobs > 1) {
                    script.print("waitMax; ");
                }
                script.print("\"$MVN\" \"$@\" gpg:sign-and-deploy-file -Durl=\"$REPO\" -DrepositoryId=$ID ");
                script.format(" -DpomFile=%s", Processor.makePomName(export));
                script.format(" -Dfile=%s", Processor.makeFileName(export));
                if (export.getClassifier() != null) {
                    script.format(" -Dclassifier=%s", export.getClassifier());
                }
                if (maxJobs > 1) {
                    script.print(" &");
                }
                script.println();
            }
            script.println();
            if (maxJobs > 1) {
                script.println("wait");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldUpload(MavenReference ref) throws Exception {
        System.out.format("baseline validation: %s%n", ref);
        String group = ref.getGroupId().replace('.', '/');
        String uri = String.format("http://central.maven.org/maven2/%s/%s/%s/%s", group, ref.getArtifactId(), ref.getVersion(), ref.toFileName());
        URL url = new URL(uri);
        HttpURLConnection con = this.openConnection(url);
        con.setAllowUserInteraction(false);
        con.setConnectTimeout(Integer.getInteger("maven.central.connectTimeout", Integer.getInteger("maven.central.timeout", 0)));
        con.setReadTimeout(Integer.getInteger("maven.central.readTimeout", Integer.getInteger("maven.central.timeout", 0)));
        con.connect();
        try {
            if (con.getResponseCode() == 404) {
                return true;
            }
            Path tmp = Files.createTempFile(null, ".jar", new FileAttribute[0]);
            try {
                block21: {
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try {
                        InputStream in = con.getInputStream();
                        try {
                            try (OutputStream out = Files.newOutputStream(tmp, new OpenOption[0]);){
                                ByteStreams.copy((InputStream)in, (OutputStream)out);
                            }
                            if (in == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                this.performBaselineCheck(Processor.makeJarFile(this.makeVersionBase(ref), ref), tmp);
                return true;
            }
            finally {
                Files.deleteIfExists(tmp);
            }
        }
        finally {
            con.disconnect();
        }
    }

    private HttpURLConnection openConnection(URL url) throws IOException {
        String host = this.properties.getProperty("local.proxy.host");
        String port = this.properties.getProperty("local.proxy.port");
        if (host != null && port != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, Integer.parseInt(port)));
            return (HttpURLConnection)url.openConnection(proxy);
        }
        return (HttpURLConnection)url.openConnection();
    }

    private void performBaselineCheck(Path newFile, Path oldFile) throws Exception {
        System.out.format("Comparing - %s - %s%n", newFile, oldFile);
        ProcessBuilder pb = new ProcessBuilder("java", "-jar", this.tmpBndTools.toString(), "baseline", newFile.toAbsolutePath().toString(), oldFile.toAbsolutePath().toString());
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        Path tmp = Files.createTempFile(null, null, new FileAttribute[0]);
        try {
            pb.redirectOutput(tmp.toFile());
            Process process = pb.start();
            process.waitFor();
            List<String> lines = Files.readAllLines(tmp, StandardCharsets.UTF_8);
            for (String line : lines) {
                if (!line.contains("MAJOR") && !line.contains("MINOR")) continue;
                this.errors.add(String.format("Baseline validation failed for: %s - %s", newFile.getFileName(), String.join((CharSequence)"\n", lines)));
            }
        }
        finally {
            Files.deleteIfExists(tmp);
        }
    }

    private static String makePomName(MavenReference export) {
        return String.format("%1$s/%2$s/%3$s/%2$s-%3$s.pom", export.getGroupId().replace('.', File.separatorChar), export.getArtifactId(), export.getVersion());
    }

    private static String makeFileName(MavenReference export) {
        String groupPath = export.getGroupId().replace('.', File.separatorChar);
        if (export.getClassifier() == null) {
            return String.format("%1$s/%2$s/%3$s/%2$s-%3$s.jar", groupPath, export.getArtifactId(), export.getVersion());
        }
        return String.format("%1$s/%2$s/%3$s/%2$s-%3$s-%4$s.jar", groupPath, export.getArtifactId(), export.getVersion(), export.getClassifier());
    }

    private void writeMetaData(MavenReference key, Set<String> value) throws Exception {
        Path base = this.makeBase(key.getGroupId(), key.getArtifactId());
        Path file = base.resolve("maven-metadata.xml");
        System.out.println("Write meta data: " + file);
        Document doc = this.documentBuilder.newDocument();
        Element main = doc.createElement("metadata");
        doc.appendChild(main);
        this.addElement(main, "groupId", key.getGroupId());
        this.addElement(main, "artifactId", key.getArtifactId());
        this.addElement(main, "version", key.getVersion());
        Element v = doc.createElement("versioning");
        main.appendChild(v);
        Element vs = doc.createElement("versions");
        v.appendChild(vs);
        for (String version : value) {
            this.addElement(vs, "version", version);
        }
        this.addElement(v, "lastUpdated", META_DF.format(new Date()));
        this.saveXml(doc, file);
        this.makeChecksum("MD5", file, base.resolve("maven-metadata.xml.md5"));
        this.makeChecksum("SHA1", file, base.resolve("maven-metadata.xml.sha1"));
    }

    private void processUnit(IInstallableUnit iu, IProgressMonitor pm) throws Exception {
        IArtifactKey art = this.findArtifact(iu);
        if (art == null) {
            System.out.println("Ignore: " + iu);
            return;
        }
        System.out.println("IU : " + iu + " -> " + art);
        if (this.ignoreMirror(iu)) {
            System.out.println("Action: SKIP");
            return;
        }
        for (Map.Entry entry : iu.getProperties().entrySet()) {
            System.out.println(String.format("\t%s -> %s", entry.getKey(), entry.getValue()));
        }
        List<MavenReference> refs = this.mapping.makeReference(iu);
        if (refs == null) {
            throw new IllegalStateException("Exported artifact must be mappable");
        }
        if (refs.size() != 1) {
            throw new IllegalStateException("Exported artifact must be mappable to exactly one Maven reference - currently: " + refs);
        }
        MavenReference ref = refs.get(0);
        System.out.println("POM : " + ref);
        Path versionBase = this.makeVersionBase(ref);
        Files.createDirectories(versionBase, new FileAttribute[0]);
        System.out.println("\tStoring to: " + versionBase);
        this.mirrorArtifact(art, versionBase, ref, pm);
        if (ref.getClassifier() == null) {
            this.processMainArtifact(iu, pm, ref, versionBase);
        }
        this.mavenExports.add(ref);
    }

    private Path makeVersionBase(MavenReference ref) {
        Path base = this.makeBase(ref.getGroupId(), ref.getArtifactId());
        return base.resolve(ref.getVersion());
    }

    private void processMainArtifact(IInstallableUnit iu, IProgressMonitor pm, MavenReference ref, Path versionBase) throws Exception {
        Set<MavenDependency> deps = this.makeDependencies(iu, pm);
        this.makePom(ref, versionBase, deps, iu);
        this.makeMetaData(ref, versionBase);
        this.makeFake(ref, versionBase, "javadoc");
        this.makeFake(ref, versionBase, "sources");
        this.mavenDependencies.addAll(deps);
    }

    private Set<MavenDependency> makeDependencies(IInstallableUnit iu, IProgressMonitor pm) throws Exception {
        HashSet<MavenDependency> result = new HashSet<MavenDependency>();
        for (IRequirement req : iu.getRequirements()) {
            List<MavenDependency> deps;
            if (!(req instanceof IRequiredCapability) || (deps = this.makeDependency(iu, (IRequiredCapability)req, pm)) == null) continue;
            result.addAll(deps);
        }
        return result;
    }

    private List<MavenDependency> makeDependency(IInstallableUnit iu, IRequiredCapability req, IProgressMonitor pm) throws Exception {
        if (this.ignoreDependency(req)) {
            return null;
        }
        System.out.println("\tDep: " + req + " NS: " + req.getNamespace());
        IInstallableUnit depIu = this.findBest(this.findCandidates((IRequirement)req, pm));
        if (depIu == null) {
            if (req.getMin() <= 0) {
                return null;
            }
            throw new IllegalArgumentException(String.format("Unable to find dependency - req: %s (min: %s)", req, req.getMin()));
        }
        if (iu.equals((Object)depIu)) {
            return null;
        }
        List<MavenReference> refs = this.mapping.makeReference(depIu);
        if (refs == null) {
            return null;
        }
        ArrayList<MavenDependency> result = new ArrayList<MavenDependency>(refs.size());
        for (MavenReference ref : refs) {
            MavenDependency dep = new MavenDependency();
            dep.setGroupId(ref.getGroupId());
            dep.setArtifactId(ref.getArtifactId());
            dep.setVersion(ref.getVersion());
            dep.setOptional(req.getMin() <= 0);
            result.add(dep);
            System.out.println("\t\tResolve to: " + result);
        }
        return result;
    }

    private Set<IInstallableUnit> findCandidates(IRequirement req, IProgressMonitor pm) {
        IQuery query = QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]);
        Set result = this.metaRepo.query(query, pm).toUnmodifiableSet();
        if (!result.isEmpty()) {
            return result;
        }
        for (IMetadataRepository repo : this.validationRepositories.values()) {
            Set result2 = repo.query(query, pm).toUnmodifiableSet();
            if (result2.isEmpty()) continue;
            return result2;
        }
        return Collections.emptySet();
    }

    private IInstallableUnit findBest(Set<IInstallableUnit> candidates) {
        if (candidates.isEmpty()) {
            return null;
        }
        return candidates.iterator().next();
    }

    private void makeMetaData(MavenReference ref, Path versionBase) throws Exception {
        Document doc = this.documentBuilder.newDocument();
        Element metadata = doc.createElement("metadata");
        doc.appendChild(metadata);
        this.addElement(metadata, "groupId", ref.getGroupId());
        this.addElement(metadata, "artifactId", ref.getArtifactId());
        this.addElement(metadata, "version", ref.getVersion());
        Path file = versionBase.resolve("maven-metadata.xml");
        this.saveXml(doc, file);
        this.makeChecksum("MD5", file, versionBase.resolve("maven-metadata.xml.md5"));
        this.makeChecksum("SHA1", file, versionBase.resolve("maven-metadata.xml.sha1"));
    }

    private void makeFake(MavenReference ref, Path versionBase, String classifier) throws Exception {
        if (!this.fakeForCentral) {
            return;
        }
        String name = String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + "-" + classifier + ".jar";
        Path file = versionBase.resolve(name);
        this.mavenExports.add(new MavenReference(ref.getGroupId(), ref.getArtifactId(), ref.getVersion(), classifier));
        if (Files.exists(file, new LinkOption[0])) {
            return;
        }
        Throwable throwable = null;
        Object var7_7 = null;
        try {
            JarOutputStream jar = new JarOutputStream(Files.newOutputStream(file, new OpenOption[0]));
            if (jar != null) {
                jar.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.makeChecksum("MD5", file, versionBase.resolve(String.valueOf(name) + ".md5"));
        this.makeChecksum("SHA1", file, versionBase.resolve(String.valueOf(name) + ".sha1"));
    }

    private void makePom(MavenReference ref, Path versionBase, Set<MavenDependency> deps, IInstallableUnit iu) throws Exception {
        String description;
        Document doc = this.documentBuilder.newDocument();
        Element project = doc.createElementNS("http://maven.apache.org/POM/4.0.0", "project");
        project.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd");
        doc.appendChild(project);
        this.addElement(project, "modelVersion", "4.0.0");
        this.addElement(project, "groupId", ref.getGroupId());
        this.addElement(project, "artifactId", ref.getArtifactId());
        this.addElement(project, "version", ref.getVersion());
        this.addElement(project, "url", this.makeProjectUrl(iu));
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (name == null) {
            name = String.format("%s:%s", ref.getGroupId(), ref.getArtifactId());
        }
        if ((description = iu.getProperty("org.eclipse.equinox.p2.description", null)) == null) {
            description = name;
        }
        this.addElement(project, "name", name);
        this.addElement(project, "description", description);
        this.addOrganization(project);
        this.addDevelopers(project);
        List<License> lics = this.licenseProvider.getLicenses(iu);
        if (lics != null) {
            this.addLicense(project, lics);
        } else if (ref.getArtifactId().startsWith("org.eclipse.")) {
            this.addLicense(project, Collections.singletonList(License.EPL));
        } else {
            this.errors.add(String.format("%s: no license information", ref));
        }
        this.makeScm(iu, doc, project, versionBase, ref);
        if (!deps.isEmpty()) {
            Element depsEle = doc.createElement("dependencies");
            project.appendChild(depsEle);
            for (MavenDependency dep : deps) {
                Element depEle = doc.createElement("dependency");
                depsEle.appendChild(depEle);
                this.addElement(depEle, "groupId", dep.getGroupId());
                this.addElement(depEle, "artifactId", dep.getArtifactId());
                this.addElement(depEle, "version", dep.getVersion());
                if (!dep.isOptional()) continue;
                this.addElement(depEle, "optional", "true");
            }
        }
        Path pomFile = versionBase.resolve(String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + ".pom");
        this.saveXml(doc, pomFile);
        this.makeChecksum("MD5", pomFile, versionBase.resolve(String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + ".pom.md5"));
        this.makeChecksum("SHA1", pomFile, versionBase.resolve(String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + ".pom.sha1"));
        this.addMetaDataVersion(ref);
    }

    private void addOrganization(Element project) {
        if (this.organizationName == null || this.organizationUrl == null) {
            return;
        }
        if (this.organizationName.isEmpty() || this.organizationUrl.isEmpty()) {
            return;
        }
        Document doc = project.getOwnerDocument();
        Element orga = doc.createElement("organization");
        project.appendChild(orga);
        this.addElement(orga, "name", this.organizationName);
        this.addElement(orga, "url", this.organizationUrl);
    }

    private void makeScm(IInstallableUnit iu, Document doc, Element project, Path versionBase, MavenReference ref) {
        String[] scmToks;
        String scm = null;
        String scmUrl = null;
        scmUrl = this.properties.getProperty("scm.url." + iu.getId());
        scm = this.properties.getProperty("scm.ref." + iu.getId());
        if (scmUrl == null && (scm = this.loadScm(versionBase, ref)) != null && (scmToks = scm.split(";", 2)).length > 0) {
            String key = "scm.url." + scmToks[0];
            scmUrl = this.properties.getProperty(key);
        }
        if (scmUrl == null) {
            this.errors.add(String.format("%s: no SCM information", iu.getId()));
            return;
        }
        Element scmEle = doc.createElement("scm");
        project.appendChild(scmEle);
        this.addElement(scmEle, "connection", scm);
        this.addElement(scmEle, "developerConnection", scm);
        this.addElement(scmEle, "url", scmUrl);
    }

    private void addDevelopers(Element project) {
        Document doc = project.getOwnerDocument();
        Element devs = doc.createElement("developers");
        project.appendChild(devs);
        for (Developer dev : this.developers) {
            Element devNode = doc.createElement("developer");
            devs.appendChild(devNode);
            this.addElement(devNode, "id", dev.id);
            this.addElement(devNode, "name", dev.name);
            this.addElement(devNode, "email", dev.email);
            this.addElement(devNode, "url", dev.url);
            this.addElement(devNode, "organization", dev.organization);
            this.addElement(devNode, "organizationUrl", dev.organizationUrl);
        }
    }

    private String loadScm(Path versionBase, MavenReference ref) {
        Path jarFile;
        block3: {
            try {
                jarFile = Processor.makeJarFile(versionBase, ref);
                if (Files.isRegularFile(jarFile, new LinkOption[0])) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.readSourceReference(jarFile);
    }

    private String readSourceReference(Path jarFile) throws IOException {
        Manifest mf = this.readManifest(jarFile);
        return mf.getMainAttributes().getValue("Eclipse-SourceReferences");
    }

    private Manifest readManifest(Path jarFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JarFile jar = new JarFile(jarFile.toFile());){
            return jar.getManifest();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Path makeJarFile(Path versionBase, MavenReference ref) {
        return versionBase.resolve(String.valueOf(ref.getArtifactId()) + "-" + ref.getVersion() + ".jar");
    }

    private void addLicense(Element project, List<License> licenses) {
        Document doc = project.getOwnerDocument();
        Element lics = doc.createElement("licenses");
        project.appendChild(lics);
        for (License license : licenses) {
            Element lic = doc.createElement("license");
            lics.appendChild(lic);
            this.addElement(lic, "name", license.getName());
            this.addElement(lic, "url", license.getUrl());
            this.addElement(lic, "distribution", "repo");
        }
    }

    private String makeProjectUrl(IInstallableUnit iu) {
        String url = iu.getProperty("org.eclipse.equinox.p2.doc.url", null);
        if (url == null || url.isEmpty()) {
            url = this.properties.getProperty("default.project.url");
        }
        return url;
    }

    private void addMetaDataVersion(MavenReference ref) {
        MavenReference metaRef = new MavenReference(ref.getGroupId(), ref.getArtifactId(), "1");
        Set<String> versions = this.metadata.get(metaRef);
        if (versions == null) {
            versions = new HashSet<String>();
            this.metadata.put(metaRef, versions);
        }
        versions.add(ref.getVersion());
    }

    private void addElement(Element parent, String name, String value) {
        if (value == null) {
            return;
        }
        Element ele = parent.getOwnerDocument().createElement(name);
        parent.appendChild(ele);
        ele.appendChild(parent.getOwnerDocument().createTextNode(value));
    }

    private void saveXml(Document doc, Path file) throws Exception {
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file.toFile());
        transformer.transform(source, result);
    }

    /*
     * Unable to fully structure code
     */
    private void mirrorArtifact(IArtifactKey art, Path versionBase, MavenReference ref, IProgressMonitor pm) throws Exception {
        block24: {
            if (this.dryRun) {
                return;
            }
            jarFile = versionBase.resolve(ref.toFileName());
            System.out.format("Storing to: %s%n", new Object[]{jarFile});
            if (this.scrubJars && ref.getClassifier() == null) {
                tmp = Files.createTempFile(null, ".jar", new FileAttribute[0]);
                try {
                    this.fetchArtifact(art, pm, tmp);
                    var7_7 = null;
                    var8_9 = null;
                    try {
                        jin = new JarInputStream(Files.newInputStream(tmp, new OpenOption[0]));
                        try {
                            jout = new JarOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]), jin.getManifest());
                            try {
                                while ((entry = jin.getNextJarEntry()) != null) {
                                    name = entry.getName();
                                    if (name.startsWith("META-INF/maven/")) {
                                        System.out.format("Scrubbing Maven information: %s%n", new Object[]{name});
                                        continue;
                                    }
                                    jout.putNextEntry(entry);
                                    ByteStreams.copy((InputStream)jin, (OutputStream)jout);
                                }
                            }
                            finally {
                                if (jout != null) {
                                    jout.close();
                                }
                            }
                            ** if (jin == null) goto lbl-1000
                        }
                        catch (Throwable var8_10) {
                            if (var7_7 == null) {
                                var7_7 = var8_10;
                            } else if (var7_7 != var8_10) {
                                var7_7.addSuppressed(var8_10);
                            }
                            if (jin != null) {
                                jin.close();
                            }
                            throw var7_7;
                        }
lbl-1000:
                        // 1 sources

                        {
                            jin.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block24;
                        }
                    }
                    catch (Throwable var8_11) {
                        if (var7_7 == null) {
                            var7_7 = var8_11;
                        } else if (var7_7 != var8_11) {
                            var7_7.addSuppressed(var8_11);
                        }
                        throw var7_7;
                    }
                }
                finally {
                    Files.deleteIfExists(tmp);
                }
            }
            this.fetchArtifact(art, pm, jarFile);
        }
        this.makeChecksum("MD5", jarFile, versionBase.resolve(ref.toFileName("md5")));
        this.makeChecksum("SHA1", jarFile, versionBase.resolve(ref.toFileName("sha1")));
    }

    private void fetchArtifact(IArtifactKey art, IProgressMonitor pm, Path targetFile) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream output = Files.newOutputStream(targetFile, new OpenOption[0]);){
            IArtifactDescriptor desc = this.artRepo.createArtifactDescriptor(art);
            this.artRepo.getArtifact(desc, output, pm);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void makeChecksum(String mdName, Path sourceFile, Path targetFile) throws Exception {
        MessageDigest md = MessageDigest.getInstance(mdName);
        byte[] buffer = new byte[4096];
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(sourceFile, new OpenOption[0]));){
            int len;
            while ((len = ((InputStream)input).read(buffer)) > 0) {
                md.update(buffer, 0, len);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        byte[] result = md.digest();
        StringBuilder sb = new StringBuilder(result.length * 2);
        byte[] byArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b));
            ++n2;
        }
        Throwable throwable3 = null;
        Object var9_15 = null;
        try (PrintWriter pw = new PrintWriter(Files.newBufferedWriter(targetFile, StandardCharsets.UTF_8, new OpenOption[0]));){
            pw.print(sb.toString());
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
    }

    private boolean ignoreMirror(IInstallableUnit iu) {
        String value = this.properties.getProperty("mirror." + iu.getId(), null);
        if (value != null) {
            return !Boolean.parseBoolean(value);
        }
        value = this.properties.getProperty("external." + iu.getId());
        return value != null;
    }

    private boolean ignoreDependency(IRequiredCapability req) {
        String ns = req.getNamespace();
        String name = req.getName();
        String value = this.properties.getProperty("dependency." + ns + "." + name + ".ignore", "false");
        return Boolean.parseBoolean(value);
    }

    private Path makeBase(String groupId, String artifactId) {
        String[] toks = groupId.split("\\.");
        Path file = this.output.toPath();
        String[] stringArray = toks;
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            file = file.resolve(tok);
            ++n2;
        }
        return file.resolve(artifactId);
    }

    private IArtifactKey findArtifact(IInstallableUnit iu) {
        for (IArtifactKey key : iu.getArtifacts()) {
            if (!"osgi.bundle".equals(key.getClassifier())) continue;
            return key;
        }
        return null;
    }

    public List<MavenDependency> getMavenDependencies() {
        ArrayList<MavenDependency> refs = new ArrayList<MavenDependency>(this.mavenDependencies);
        Collections.sort(refs, MavenDependency.COMPARATOR);
        return refs;
    }

    public List<MavenReference> getMavenExports() {
        ArrayList<MavenReference> result = new ArrayList<MavenReference>(this.mavenExports);
        Collections.sort(result, MavenReference.COMPARATOR);
        return result;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private static class Developer {
        String id;
        String name;
        String email;
        String url;
        String organization;
        String organizationUrl;

        private Developer() {
        }
    }
}

