/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery.local;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.osgi.services.discovery.local.FileBasedDiscoveryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.discovery.ServiceEndpointDescription;
import org.osgi.service.discovery.ServicePublication;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServicePublicationTracker
implements ServiceTrackerCustomizer {
    private BundleContext context = null;
    private FileBasedDiscoveryImpl discovery = null;
    private Map publicationAndSED = null;

    public ServicePublicationTracker(BundleContext ctx, FileBasedDiscoveryImpl disco) {
        this.context = ctx;
        this.discovery = disco;
        this.publicationAndSED = Collections.synchronizedMap(new HashMap());
    }

    public Object addingService(ServiceReference arg0) {
        ServicePublication sp = this.publishServicePublication(arg0);
        return sp;
    }

    public void modifiedService(ServiceReference arg0, Object arg1) {
        this.unpublishServicePublication(arg0);
        this.publishServicePublication(arg0);
    }

    public void removedService(ServiceReference arg0, Object arg1) {
        this.unpublishServicePublication(arg0);
    }

    private ServicePublication publishServicePublication(ServiceReference arg0) {
        ServicePublication sp = (ServicePublication)this.context.getService(arg0);
        ServiceEndpointDescription sed = this.discovery.publishService((Collection)arg0.getProperty("osgi.remote.service.interfaces"), (Collection)arg0.getProperty("osgi.remote.service.interfaces.version"), (Collection)arg0.getProperty("osgi.remote.endpoint.interfaces"), (Map)arg0.getProperty("osgi.remote.discovery.publication.service.properties"), "push", (String)arg0.getProperty("osgi.remote.endpoint.id"));
        this.publicationAndSED.put(arg0, sed);
        return sp;
    }

    private void unpublishServicePublication(ServiceReference srvReference) {
        this.discovery.unpublishService((ServiceEndpointDescription)this.publicationAndSED.get(srvReference));
        this.publicationAndSED.remove(srvReference);
    }
}

