/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.ebpm.core.SpagicUtils;

public class SpagicNode {
    public static String id() {
        String nodeId = System.getProperty("SPAGIC_NODE_IDENTIFIER");
        return nodeId;
    }

    private static String hostName() {
        String hostName = System.getProperty("SPAGIC_NODE_HOST_NAME");
        if (hostName == null || hostName.trim().length() == 0) {
            return "localhost";
        }
        return hostName;
    }

    private static InetAddress inetAddress() throws UnknownHostException {
        String hostName = SpagicNode.hostName();
        InetAddress addr = null;
        addr = hostName.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(hostName);
        return addr;
    }

    public static String ipAddress() {
        try {
            return SpagicNode.inetAddress().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "127.0.0.1";
        }
    }

    public static String host() {
        try {
            return SpagicNode.inetAddress().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public static Integer adminPort() {
        return Integer.valueOf(System.getProperty("SPAGIC_NODE_ADMIN_PORT"));
    }

    public static Integer sslPort() {
        return Integer.valueOf(System.getProperty("SPAGIC_NODE_SSL_PORT"));
    }

    public static String baseTopic() {
        return SpagicUtils.normalizeTopic("SPAGIC/MESSAGES/" + SpagicNode.id() + "/");
    }

    public static String topicForService(String localServiceId) {
        String topic = String.valueOf(SpagicNode.baseTopic()) + localServiceId;
        return SpagicUtils.normalizeTopic(topic);
    }

    public static String topicForServiceAndExternalNode(String localServiceId, String nodeId) {
        String topic = "SPAGIC/MESSAGES/" + nodeId + "/" + localServiceId;
        return SpagicUtils.normalizeTopic(topic);
    }

    public static String nodeType() {
        return System.getProperty("SPAGIC_NODE_TYPE");
    }

    public static boolean isMaster() {
        return SpagicNode.nodeType() != null ? SpagicNode.nodeType().equalsIgnoreCase("master") : true;
    }

    public static boolean isSlave() {
        return SpagicNode.nodeType() != null ? SpagicNode.nodeType().equalsIgnoreCase("slave") : false;
    }

    public static boolean isClusteredEnabled() {
        String clusterEnabled = System.getProperty("isClustered");
        return clusterEnabled != null ? Boolean.valueOf(clusterEnabled) : false;
    }

    public static String clusterId() {
        return System.getProperty("clusterId");
    }

    public static String referredMaster() {
        return System.getProperty("masterId");
    }

    public static boolean masterSlaveEnabled() {
        String masterSlaveEnabled = System.getProperty("isMasterSlave");
        return masterSlaveEnabled != null ? Boolean.valueOf(masterSlaveEnabled) : false;
    }

    public static String masterSlaveClusterId() {
        if (SpagicNode.isMaster()) {
            return String.valueOf(SpagicNode.id()) + "MasterSlave";
        }
        if (SpagicNode.isSlave()) {
            return String.valueOf(SpagicNode.referredMaster()) + "MasterSlave";
        }
        return null;
    }
}

