/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.identity;

import java.net.URI;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.provider.jms.Messages;
import org.eclipse.ecf.provider.jms.identity.JMSID;

public class JMSNamespace
extends Namespace {
    private static final long serialVersionUID = 3761689000414884151L;
    private static final String SCHEME = "jms";
    public static final String NAME = "ecf.namespace.jmsid";

    public JMSNamespace() {
        super(NAME, null);
    }

    public ID createInstance(Object[] args) throws IDCreateException {
        try {
            String init = this.getInitFromExternalForm(args);
            if (init != null) {
                return new JMSID(this, init);
            }
            if (args.length == 1) {
                if (args[0] instanceof String) {
                    return new JMSID(this, (String)args[0]);
                }
                if (args[0] instanceof URI) {
                    return new JMSID(this, ((URI)args[0]).toString());
                }
            }
            throw new IllegalArgumentException(Messages.JMSNamespace_EXCEPTION_XMPP_ARGS_INVALID);
        }
        catch (Exception e) {
            throw new IDCreateException(Messages.JMSNamespace_EXCEPTION_IDCREATION, (Throwable)e);
        }
    }

    public String getScheme() {
        return SCHEME;
    }

    private String getInitFromExternalForm(Object[] args) {
        String arg;
        if (args == null || args.length < 1 || args[0] == null) {
            return null;
        }
        if (args[0] instanceof String && (arg = (String)args[0]).startsWith(String.valueOf(this.getScheme()) + ":")) {
            int index = arg.indexOf(":");
            if (index >= arg.length()) {
                return null;
            }
            return arg.substring(index + 1);
        }
        return null;
    }

    public Class[][] getSupportedParameterTypes() {
        return new Class[][]{{String.class}, {URI.class}};
    }
}

