/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.jdbc.config;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.ebpm.components.jdbc.config.QueryParameterConfig;
import org.eclipse.ebpm.xmlutil.EXMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JDBCParameterFactory {
    private static final Logger log = LoggerFactory.getLogger(JDBCParameterFactory.class);
    private static JDBCParameterFactory singleton;

    public static JDBCParameterFactory getInstance() {
        if (singleton == null) {
            singleton = new JDBCParameterFactory();
        }
        return singleton;
    }

    public Object initializeParameter(Document doc, EXMLUtils xmlUtils, QueryParameterConfig config) throws Exception {
        Object xmlValue = this.retrieveMessageInEnvelope(doc, xmlUtils, config.getXpath());
        log.debug("Converting value: " + xmlValue + " to type: " + this.getClassFromConfig(config));
        Object value = ConvertUtils.convert((String)((String)xmlValue), (Class)this.getClassFromConfig(config));
        if (this.isBase64(this.retrieveParamType(config))) {
            return Base64.decodeBase64((byte[])value.toString().getBytes());
        }
        return value;
    }

    private Object retrieveMessageInEnvelope(Document doc, EXMLUtils xmlUtils, String xpathString) throws Exception {
        if (xpathString.startsWith("node(")) {
            String nodeSelectionXPath = xpathString.substring(xpathString.indexOf("(") + 1, xpathString.indexOf(")"));
            Element n = xmlUtils.selectNode((Node)doc, nodeSelectionXPath);
            if (n == null) {
                log.warn("Node Selected by expression [" + nodeSelectionXPath + "] is NULL");
                return "";
            }
            return xmlUtils.asXML((Node)n, true);
        }
        String nmEnvelope = xmlUtils.valueOf((Node)doc, xpathString);
        if (nmEnvelope == null) {
            log.warn("No nodes were selected by expression [" + xpathString + "]");
        } else if (nmEnvelope.trim().length() == 0) {
            log.warn("Empty String were selected by expression [" + xpathString + "]");
        }
        return nmEnvelope;
    }

    private boolean isBase64(String paramType) {
        return QueryParameterConfig.BINARY_BASE64_TYPE.equals(paramType);
    }

    private Class getClassFromConfig(QueryParameterConfig config) throws ClassNotFoundException {
        String pType = this.retrieveParamType(config);
        if (this.isBase64(pType)) {
            return String.class;
        }
        return Class.forName(pType);
    }

    private String retrieveParamType(QueryParameterConfig config) {
        String t = config.getParamType();
        if (t.indexOf("(") > 0 && t.indexOf(")") > 0) {
            t = t.substring(t.indexOf("(") + 1, t.indexOf(")"));
        }
        return t;
    }
}

