/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.jdbc;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;

public class TypesUtils {
    static Map<String, Integer> sqlTypesNameToInt;
    static Map<Integer, String> sqlTypesIntToName;

    static {
        TypesUtils.initializeMap();
    }

    public static void initializeMap() {
        sqlTypesIntToName = new HashMap<Integer, String>();
        sqlTypesNameToInt = new HashMap<String, Integer>();
        Field[] fields = Types.class.getFields();
        int i = 0;
        while (i < fields.length) {
            try {
                String name = fields[i].getName();
                Integer value = (Integer)fields[i].get(null);
                TypesUtils.add(name, value);
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++i;
        }
        TypesUtils.add("ORA.TIMESTAMPNS", -100);
        TypesUtils.add("ORA.TIMESTAMPTZ", -101);
        TypesUtils.add("ORA.TIMESTAMPLTZ", -102);
        TypesUtils.add("ORA.INTERVALYM", -103);
        TypesUtils.add("ORA.INTERVALDS", -104);
        TypesUtils.add("ORA.ROWID", -8);
        TypesUtils.add("ORA.CURSOR", -10);
        TypesUtils.add("ORA.BFILE", -13);
        TypesUtils.add("ORA.OPAQUE", 2007);
        TypesUtils.add("ORA.JAVA_STRUCT", 2008);
        TypesUtils.add("ORA.PLSQL_INDEX_TABLE", -14);
        TypesUtils.add("ORA.BINARY_FLOAT", 100);
        TypesUtils.add("ORA.BINARY_DOUBLE", 101);
        TypesUtils.add("ORA.NUMBER", 2);
        TypesUtils.add("ORA.RAW", -2);
        TypesUtils.add("ORA.FIXED_CHAR", 999);
    }

    public static int getSqlTypeByName(String name) {
        return sqlTypesNameToInt.get(name);
    }

    public static void add(String name, Integer value) {
        sqlTypesIntToName.put(value, name);
        sqlTypesNameToInt.put(name, value);
    }
}

