/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.filesystem.adapters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.eclipse.ebpm.connectors.filesystem.adapters.IFileAdapter;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;

public class BinaryFileAdapter
implements IFileAdapter {
    @Override
    public String getOutputFileName(Exchange exchange, Message in) {
        String fileName = null;
        fileName = (String)in.getHeader("spagic.filename");
        if (fileName == null) {
            fileName = (String)exchange.getProperty("spagic.filename");
        }
        return fileName;
    }

    @Override
    public void writeMessage(Exchange exchange, Message in, BufferedWriter bw) throws Exception {
        throw new UnsupportedOperationException("Binary Marshaller doesn't support messages writing yet");
    }

    @Override
    public void readFile(Exchange exchange, Message in, InputStream is, String filePath) throws Exception {
        int len;
        File polledFile = new File(filePath);
        File tempFile = File.createTempFile("spagic-attachment", ".tmp");
        FileOutputStream out = new FileOutputStream(tempFile);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        is.close();
        DataHandler handler = new DataHandler((DataSource)new FileDataSource(tempFile));
        in.addAttachment(polledFile.getName(), (Object)handler);
        in.setHeader("spagic.filename", (Object)polledFile.getName());
        in.setHeader("spagic.filepath", (Object)filePath);
        in.setBody("<FILE>" + polledFile.getName() + "</FILE>");
    }

    @Override
    public String getAdapterId() {
        return "BINARY";
    }
}

