/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.bot.impl;

import java.util.List;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.bot.Messages;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.bot.IIMBotEntry;
import org.eclipse.ecf.presence.bot.IIMMessageHandlerEntry;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;

public class IMBot
implements IIMMessageListener {
    protected IIMBotEntry bot;
    protected IContainer container;
    protected ID targetID;
    static /* synthetic */ Class class$0;

    public IMBot(IIMBotEntry bot) {
        this.bot = bot;
    }

    protected void fireInitBot() {
        List commands = this.bot.getCommands();
        int i = 0;
        while (i < commands.size()) {
            IIMMessageHandlerEntry entry = (IIMMessageHandlerEntry)commands.get(i);
            entry.getHandler().init(this.bot);
            ++i;
        }
    }

    protected void firePreConnect() {
        List commands = this.bot.getCommands();
        int i = 0;
        while (i < commands.size()) {
            IIMMessageHandlerEntry entry = (IIMMessageHandlerEntry)commands.get(i);
            entry.getHandler().preContainerConnect(this.container, this.targetID);
            ++i;
        }
    }

    public synchronized void connect() throws ECFException {
        this.fireInitBot();
        try {
            Namespace namespace = null;
            if (this.container != null) {
                throw new ContainerConnectException(Messages.DefaultChatRoomBot_EXCEPTION_ALREADY_CONNECTED);
            }
            this.container = ContainerFactory.getDefault().createContainer(this.bot.getContainerFactoryName());
            namespace = this.container.getConnectNamespace();
            this.targetID = IDFactory.getDefault().createID(namespace, this.bot.getConnectID());
            this.firePreConnect();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IPresenceContainerAdapter presenceAdapter = (IPresenceContainerAdapter)this.container.getAdapter((Class)clazz);
            presenceAdapter.getChatManager().addMessageListener((IIMMessageListener)this);
            String password = this.bot.getPassword();
            IConnectContext context = password == null ? null : ConnectContextFactory.createPasswordConnectContext((String)password);
            this.container.connect(this.targetID, context);
        }
        catch (ECFException e) {
            if (this.container != null) {
                if (this.container.getConnectedID() != null) {
                    this.container.disconnect();
                }
                this.container.dispose();
            }
            this.container = null;
            throw e;
        }
    }

    public void handleMessageEvent(IIMMessageEvent event) {
        if (event instanceof IChatMessageEvent) {
            IChatMessageEvent imEvent = (IChatMessageEvent)event;
            IChatMessage message = imEvent.getChatMessage();
            List commands = this.bot.getCommands();
            int i = 0;
            while (i < commands.size()) {
                IIMMessageHandlerEntry entry = (IIMMessageHandlerEntry)commands.get(i);
                entry.handleIMMessage(message);
                ++i;
            }
        }
    }
}

