/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.management.resources;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.datasource.IDataSourceManager;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;

public class DeployResourceService
extends BaseSpagicService {
    protected final AtomicReference<IDataSourceManager> datasourceManager = new AtomicReference<Object>(null);

    public IDataSourceManager getDataSourceManager() {
        return this.datasourceManager.get();
    }

    public void setDataSourceManager(IDataSourceManager dsm) {
        this.datasourceManager.set(dsm);
    }

    public void unsetDataSourceManager(IDataSourceManager dsManager) {
        this.datasourceManager.compareAndSet(dsManager, null);
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        Document doc = DocumentHelper.parseText((String)in.getBodyText());
        Document responseDoc = DocumentHelper.createDocument();
        Element rootResponse = responseDoc.addElement("DEPLOYMENT_RESULT");
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("spagic", "urn:eng:spagic");
        Element spagicPayloadElement = doc.getRootElement();
        Element datasourceElements = spagicPayloadElement.element("DEPLOY_DATASOURCES");
        List nodes = datasourceElements.elements("DATASOURCE");
        for (Element n : nodes) {
            String id = n.attributeValue("name");
            Element rNode = rootResponse.addElement("DATASOURCE_DEPLOY_RESULT");
            rNode.addAttribute("name", id);
            try {
                this.datasourceManager.get().getDataSource(id);
                rNode.addAttribute("status", "already_deployed");
            }
            catch (Exception exception) {
                boolean result = this.deployDSFile(id, this.getSpagicDSDescriptor(id, n));
                if (result) {
                    rNode.addAttribute("status", "successfully_deployed");
                    continue;
                }
                rNode.addAttribute("status", "not_deployed");
            }
        }
        out.setBody(responseDoc.asXML());
        return true;
    }

    public String getSpagicDSDescriptor(String id, Element n) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<spagic:ds ");
        sb.append("    xmlns:spagic=\"urn:org:spagic3\"");
        sb.append("     xmlns=\"urn:org:spagic3\"");
        sb.append("    id=\"" + id + "\">");
        sb.append("<property name=\"driverClassName\" value=\"" + n.attributeValue("driver") + "\"/>");
        sb.append("<property name=\"url\" value=\"" + n.attributeValue("url") + "\"/>");
        sb.append("<property name=\"username\" value=\"" + n.attributeValue("user") + "\"/>");
        sb.append("<property name=\"password\" value=\"" + n.attributeValue("password") + "\"/>");
        sb.append("</spagic:ds>\n");
        return sb.toString();
    }

    public boolean deployDSFile(String id, String xml) {
        try {
            String home = System.getProperty("spagic.home");
            String datasourcesFolder = String.valueOf(home) + File.separator + "datasources";
            this.checkOrCreateFolder(datasourcesFolder);
            File f = new File(String.valueOf(datasourcesFolder) + File.separator + id + ".ds");
            PrintWriter pw = new PrintWriter(new FileWriter(f));
            pw.print(xml);
            pw.flush();
            pw.close();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void checkOrCreateFolder(String fName) throws Exception {
        File f = new File(String.valueOf(fName) + File.separator);
        if (!f.exists()) {
            f.mkdirs();
        }
    }
}

