/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.ftp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.eclipse.ebpm.connectors.ftp.FtpPollerComponent;
import org.eclipse.ebpm.connectors.ftp.IFtpReader;
import org.eclipse.ebpm.connectors.ftp.locks.LockManager;
import org.eclipse.ebpm.connectors.ftp.locks.SimpleLockManager;
import org.eclipse.ebpm.connectors.ftp.marshaler.FileMarshaler;
import org.eclipse.ebpm.connectors.ftp.temporaryData.FtpData;
import org.eclipse.ebpm.core.routing.IMessageRouter;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingTask
extends TimerTask {
    protected Logger log = LoggerFactory.getLogger(FtpPollerComponent.class);
    private IFtpReader poller;
    private LockManager lockManager;
    private ConcurrentMap<String, FtpData> openExchanges = new ConcurrentHashMap<String, FtpData>();
    private boolean messageSent;
    private String target = null;
    private FileMarshaler marshaler;

    @Override
    public void run() {
        try {
            IMessageRouter router = this.poller.getMessageRouter();
            if (!router.isServiceRegistered(this.target)) {
                this.log.warn("Target Service [" + this.target + "] is not Registered, cannot fire message");
                return;
            }
        }
        catch (Throwable th) {
            this.log.error("Error during polling ", th);
            return;
        }
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager();
        }
        try {
            this.marshaler = this.poller.getMarshaler();
            if (this.marshaler != null) {
                this.pollFileOrDirectory(this.poller.getWorkingPath());
            }
        }
        catch (Exception e) {
            this.log.error("Error while polling directory: " + this.poller.getWorkingPath(), (Throwable)e);
        }
    }

    protected void pollFileOrDirectory(String fileOrDirectory) throws Exception {
        FTPClient ftp = this.borrowClient();
        try {
            this.log.debug("Polling directory " + fileOrDirectory);
            this.pollFileOrDirectory(ftp, fileOrDirectory, this.poller.isRecursive());
        }
        finally {
            this.returnClient(ftp);
        }
    }

    protected void pollFileOrDirectory(FTPClient ftp, String fileOrDirectory, boolean processDir) throws Exception {
        FTPFile[] files = this.listFiles(ftp, fileOrDirectory);
        int i = 0;
        while (i < files.length) {
            String name = files[i].getName();
            if (!".".equals(name) && !"..".equals(name)) {
                String file = String.valueOf(fileOrDirectory) + "/" + name;
                if (!files[i].isDirectory()) {
                    if (this.poller.getFilter() == null || this.poller.getFilter().accept(new File(file))) {
                        this.pollFile(file);
                    }
                } else if (processDir) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Polling directory " + file);
                    }
                    this.pollFileOrDirectory(ftp, file, this.poller.isRecursive());
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Skipping directory " + file);
                }
            }
            ++i;
        }
    }

    protected void pollFile(String file) {
        Lock lock;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Scheduling file " + file + " for processing");
        }
        if ((lock = this.lockManager.getLock(file)).tryLock()) {
            this.processFileNow(file);
        }
    }

    private void unlockAsyncFile(String file) {
        Lock lock = this.lockManager.getLock(file);
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (Exception ex) {
                this.log.error("Error trying to release the lock ", (Throwable)ex);
            }
        }
    }

    protected FTPClient borrowClient() throws Exception {
        try {
            return (FTPClient)this.poller.getClientPool().borrowClient();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    protected void processFileNow(String file) {
        block9: {
            FTPClient ftp = null;
            try {
                try {
                    ftp = this.borrowClient();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Processing file " + file);
                    }
                    if (this.listFiles(ftp, file).length > 0) {
                        this.processFile(ftp, file);
                        ftp = null;
                        break block9;
                    }
                    this.log.debug("Skipping " + file + ": the file no longer exists on the server");
                }
                catch (Exception e) {
                    this.log.error("Failed to process file: " + file + ". Reason: " + e, (Throwable)e);
                    if (ftp != null) {
                        this.returnClient(ftp);
                    }
                }
            }
            finally {
                if (ftp != null) {
                    this.returnClient(ftp);
                }
            }
        }
    }

    protected void returnClient(FTPClient client) {
        if (client != null) {
            try {
                this.poller.getClientPool().returnClient((SocketClient)client);
            }
            catch (Exception e) {
                this.log.error("Failed to return client to pool: " + e, (Throwable)e);
            }
        }
    }

    private FTPFile[] listFiles(FTPClient ftp, String directory) throws IOException {
        if (this.poller.isChangeWorkingDirectory()) {
            ftp.changeWorkingDirectory(directory);
            return ftp.listFiles();
        }
        return ftp.listFiles(directory);
    }

    protected void processFile(FTPClient ftp, String file) throws Exception {
        if (this.marshaler != null) {
            InputStream in = ftp.retrieveFileStream(file);
            Exchange exchange = this.poller.getFtpExchange();
            Message message = this.poller.getMessage(exchange);
            this.marshaler.readMessage(exchange, message, in, file);
            if (this.poller.isStateless()) {
                exchange.setProperty(FtpData.class.getName(), (Object)new FtpData(file, ftp, in));
            } else {
                this.openExchanges.put(exchange.getId(), new FtpData(file, ftp, in));
            }
            this.poller.sendFtpExchange(exchange);
            this.messageSent = true;
        }
    }

    public PollingTask(IFtpReader poller, String target) throws Exception {
        this.poller = poller;
        this.target = target;
        this.messageSent = false;
    }

    protected LockManager createLockManager() {
        return new SimpleLockManager();
    }

    public void process(Exchange exchange) throws Exception {
        block7: {
            FtpData data = this.poller.isStateless() ? (FtpData)exchange.getProperty(FtpData.class.getName()) : (FtpData)this.openExchanges.remove(exchange.getId());
            if (data != null) {
                this.log.debug("Releasing " + data.file);
                try {
                    data.in.close();
                    data.ftp.completePendingCommand();
                    if (exchange.getStatus() == Status.Done) {
                        if (this.poller.isDeleteFile() && !data.ftp.deleteFile(data.file)) {
                            throw new IOException("Could not delete file " + data.file);
                        }
                        break block7;
                    }
                    Exception e = exchange.getError();
                    if (e == null) {
                        e = new Exception("Unkown error");
                    }
                    throw e;
                }
                finally {
                    this.unlockAsyncFile(data.file);
                    this.returnClient(data.ftp);
                }
            }
            this.log.debug("Received unknown exchange. Will be ignored...");
        }
    }

    public boolean isMessageSent() {
        return this.messageSent;
    }
}

