/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.interceptors.wsdl;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Binding;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.bindings.soap.SoapFault;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;

public class WsdlOperationInInterceptor
extends AbstractInterceptor {
    @Override
    public void handleMessage(Message message) {
        if (message.get(Operation.class) != null) {
            return;
        }
        XMLStreamReader reader = message.getContent(XMLStreamReader.class);
        if (reader == null || reader.getEventType() != 1) {
            return;
        }
        Binding binding = message.get(Binding.class);
        ArrayList<Operation> matching = new ArrayList<Operation>();
        QName name = reader.getName();
        for (Operation oper : binding.getOperations()) {
            if (!name.equals(((org.eclipse.ebpm.soap.api.model.Message)oper.getInput()).getElementName())) continue;
            matching.add(oper);
        }
        if (matching.size() != 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("No matching operation found for element: ");
            sb.append(name);
            sb.append("\n");
            sb.append("Expected one of: \n");
            for (Operation oper : binding.getOperations()) {
                sb.append("  - ");
                sb.append(((org.eclipse.ebpm.soap.api.model.Message)oper.getInput()).getElementName());
                sb.append("\n");
            }
            throw new SoapFault(SoapFault.SENDER, sb.toString());
        }
        Operation op = (Operation)matching.get(0);
        message.put(Operation.class, op);
        message.put(org.eclipse.ebpm.soap.api.model.Message.class, op.getInput());
    }
}

