/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.bindings.soap.impl;

import java.util.List;
import org.eclipse.ebpm.soap.api.Interceptor;
import org.eclipse.ebpm.soap.api.InterceptorProvider;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.bindings.soap.SoapVersion;
import org.eclipse.ebpm.soap.bindings.soap.interceptors.MustUnderstandInterceptor;
import org.eclipse.ebpm.soap.bindings.soap.interceptors.SoapActionInOperationInterceptor;
import org.eclipse.ebpm.soap.bindings.soap.interceptors.SoapActionOutOperationInterceptor;
import org.eclipse.ebpm.soap.bindings.soap.interceptors.SoapDOM4JOutInterceptor;
import org.eclipse.ebpm.soap.bindings.soap.interceptors.SoapFaultInInterceptor;
import org.eclipse.ebpm.soap.bindings.soap.interceptors.SoapFaultOutInterceptor;
import org.eclipse.ebpm.soap.bindings.soap.interceptors.SoapInInterceptor;
import org.eclipse.ebpm.soap.bindings.soap.interceptors.SoapOutInterceptor;
import org.eclipse.ebpm.soap.bindings.soap.model.wsdl1.Wsdl1SoapBinding;
import org.eclipse.ebpm.soap.bindings.soap.model.wsdl1.Wsdl1SoapOperation;
import org.eclipse.ebpm.soap.core.model.AbstractBinding;
import org.eclipse.ebpm.soap.interceptors.mime.AttachmentsInInterceptor;
import org.eclipse.ebpm.soap.interceptors.mime.AttachmentsOutInterceptor;
import org.eclipse.ebpm.soap.interceptors.nmr.NmrFaultOutInterceptor;
import org.eclipse.ebpm.soap.interceptors.nmr.NmrInInterceptor;
import org.eclipse.ebpm.soap.interceptors.nmr.NmrOutInterceptor;
import org.eclipse.ebpm.soap.interceptors.nmr.NmrWSDL1Interceptor;
import org.eclipse.ebpm.soap.interceptors.wsdl.WsdlOperationInInterceptor;
import org.eclipse.ebpm.soap.interceptors.xml.BodyOutInterceptor;
import org.eclipse.ebpm.soap.interceptors.xml.StaxInInterceptor;
import org.eclipse.ebpm.soap.interceptors.xml.StaxOutInterceptor;

public class Wsdl1SoapBindingImpl
extends AbstractBinding<Wsdl1SoapOperation>
implements Wsdl1SoapBinding {
    private SoapVersion soapVersion;
    private String locationURI;
    private String transportURI;
    private Wsdl1SoapBinding.Style style;

    public Wsdl1SoapBindingImpl() {
        this(null);
    }

    public Wsdl1SoapBindingImpl(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
        List<Interceptor> phase = this.getInterceptors(InterceptorProvider.Phase.ServerIn);
        phase.add(new AttachmentsInInterceptor());
        phase.add(new StaxInInterceptor());
        phase.add(new SoapInInterceptor(soapVersion));
        phase.add(new SoapActionInOperationInterceptor());
        phase.add(new WsdlOperationInInterceptor());
        phase.add(new MustUnderstandInterceptor());
        phase.add(new NmrWSDL1Interceptor(true));
        phase.add(new NmrInInterceptor(true));
        phase = this.getInterceptors(InterceptorProvider.Phase.ServerOut);
        phase.add(new NmrFaultOutInterceptor());
        phase.add(new NmrOutInterceptor(true));
        phase.add(new AttachmentsOutInterceptor());
        phase.add(new StaxOutInterceptor());
        phase.add(new SoapOutInterceptor(soapVersion));
        phase.add(new BodyOutInterceptor());
        phase = this.getInterceptors(InterceptorProvider.Phase.ServerOutFault);
        phase.add(new SoapFaultOutInterceptor());
        phase = this.getInterceptors(InterceptorProvider.Phase.ClientOut);
        phase.add(new NmrOutInterceptor(false));
        phase.add(new SoapActionOutOperationInterceptor());
        phase.add(new AttachmentsOutInterceptor());
        phase.add(new SoapDOM4JOutInterceptor(soapVersion));
        phase = this.getInterceptors(InterceptorProvider.Phase.ClientIn);
        phase.add(new AttachmentsInInterceptor());
        phase.add(new StaxInInterceptor());
        phase.add(new SoapInInterceptor());
        phase.add(new SoapFaultInInterceptor());
        phase.add(new NmrWSDL1Interceptor(false));
        phase.add(new NmrInInterceptor(false));
    }

    @Override
    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    @Override
    public String getTransportURI() {
        return this.transportURI;
    }

    public void setTransportURI(String transportURI) {
        this.transportURI = transportURI;
    }

    @Override
    public Wsdl1SoapBinding.Style getStyle() {
        return this.style;
    }

    public void setStyle(Wsdl1SoapBinding.Style style) {
        this.style = style;
    }

    @Override
    public Message createMessage() {
        Message msg = super.createMessage();
        if (msg.get(SoapVersion.class) == null && this.soapVersion != null) {
            msg.put(SoapVersion.class, this.soapVersion);
        }
        return msg;
    }

    @Override
    public Message createMessage(Message request) {
        Message msg = super.createMessage(request);
        if (msg.get(SoapVersion.class) == null && request.get(SoapVersion.class) != null) {
            msg.put(SoapVersion.class, request.get(SoapVersion.class));
        }
        if (msg.get(SoapVersion.class) == null && this.soapVersion != null) {
            msg.put(SoapVersion.class, this.soapVersion);
        }
        return msg;
    }
}

