/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.LaunchListener;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.log.LogView;

public class LaunchTerminationStatusHandler
implements IStatusHandler {
    public static final int OPEN_IN_ERROR_LOG_VIEW = 0;
    public static final int OPEN_IN_SYSTEM_EDITOR = 1;

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        if (status.getCode() == 13) {
            this.handleOtherReasonsFoundInLog((ILaunch)source);
        } else if (status.getCode() == 15) {
            this.handleWorkspaceInUse();
        }
        return null;
    }

    private void handleWorkspaceInUse() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Launcher_error_title, (String)PDEMessages.Launcher_error_code15);
            }
        });
    }

    private void handleOtherReasonsFoundInLog(final ILaunch launch) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    File log = LaunchListener.getMostRecentLogFile((ILaunchConfiguration)launch.getLaunchConfiguration());
                    if (log != null && log.exists()) {
                        MessageDialog dialog = new MessageDialog(PDEPlugin.getActiveWorkbenchShell(), PDEUIMessages.Launcher_error_title, null, PDEUIMessages.Launcher_error_code13, 1, new String[]{PDEUIMessages.Launcher_error_displayInLogView, PDEUIMessages.Launcher_error_displayInSystemEditor, IDialogConstants.NO_LABEL}, 0);
                        int dialog_value = dialog.open();
                        if (dialog_value == 0) {
                            LogView errlog = (LogView)PDEPlugin.getActivePage().showView("org.eclipse.pde.runtime.LogView");
                            errlog.handleImportPath(log.getAbsolutePath());
                            errlog.sortByDateDescending();
                        } else if (dialog_value == 1) {
                            LaunchTerminationStatusHandler.this.openInEditor(log);
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
        });
    }

    private void openInEditor(File log) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(log.getAbsolutePath()));
        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
            IWorkbenchPage page = ww.getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {}
        }
    }
}

