/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.build.BuildObject;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.core.plugin.AttributeChangedEvent;
import org.eclipse.pde.internal.core.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginLibraryNode;
import org.eclipse.pde.internal.core.text.plugin.PluginObjectNode;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;

public class PluginUndoManager
extends ModelUndoManager {
    public PluginUndoManager(PDEFormEditor editor) {
        super(editor);
        this.setUndoLevelLimit(30);
    }

    protected String getPageId(Object obj) {
        if (obj instanceof IPluginBase) {
            return "overview";
        }
        if (obj instanceof IPluginImport) {
            return "dependencies";
        }
        if (obj instanceof IPluginLibrary || obj instanceof IPluginElement && ((IPluginElement)obj).getParent() instanceof IPluginLibrary) {
            return "runtime";
        }
        if (obj instanceof IPluginExtension || obj instanceof IPluginElement && ((IPluginElement)obj).getParent() instanceof IPluginParent || obj instanceof IPluginAttribute) {
            return "extensions";
        }
        if (obj instanceof IPluginExtensionPoint) {
            return "ex-points";
        }
        return null;
    }

    protected void execute(IModelChangedEvent event, boolean undo) {
        Object[] elements = event.getChangedObjects();
        int type = event.getChangeType();
        String propertyName = event.getChangedProperty();
        IModelChangeProvider model = event.getChangeProvider();
        switch (type) {
            case 1: {
                if (undo) {
                    this.executeRemove(model, elements);
                    break;
                }
                this.executeAdd(model, elements);
                break;
            }
            case 2: {
                if (undo) {
                    this.executeAdd(model, elements);
                    break;
                }
                this.executeRemove(model, elements);
                break;
            }
            case 3: {
                if (event instanceof AttributeChangedEvent) {
                    this.executeAttributeChange((AttributeChangedEvent)event, undo);
                    break;
                }
                if (undo) {
                    this.executeChange(elements[0], propertyName, event.getNewValue(), event.getOldValue());
                    break;
                }
                this.executeChange(elements[0], propertyName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    private void executeAdd(IModelChangeProvider model, Object[] elements) {
        IPluginBase pluginBase = null;
        IBuild build = null;
        if (model instanceof IPluginModelBase) {
            pluginBase = ((IPluginModelBase)model).getPluginBase();
        }
        if (model instanceof IBuildModel) {
            build = ((IBuildModel)model).getBuild();
        }
        try {
            int i = 0;
            while (i < elements.length) {
                IPluginElement e;
                Object element = elements[i];
                if (element instanceof IPluginImport) {
                    pluginBase.add((IPluginImport)element);
                } else if (element instanceof IPluginLibrary) {
                    pluginBase.add((IPluginLibrary)element);
                } else if (element instanceof IPluginExtensionPoint) {
                    pluginBase.add((IPluginExtensionPoint)element);
                } else if (element instanceof IPluginExtension) {
                    pluginBase.add((IPluginExtension)element);
                } else if (element instanceof IPluginElement) {
                    e = (IPluginElement)element;
                    IPluginObject parent = e.getParent();
                    if (parent instanceof PluginLibraryNode && e instanceof PluginElementNode) {
                        ((PluginLibraryNode)parent).addContentFilter((PluginElementNode)e);
                    } else if (parent instanceof IPluginParent) {
                        ((IPluginParent)parent).add((IPluginObject)e);
                    }
                } else if (element instanceof IBuildEntry) {
                    e = (IBuildEntry)element;
                    build.add((IBuildEntry)e);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeRemove(IModelChangeProvider model, Object[] elements) {
        IPluginBase pluginBase = null;
        IBuild build = null;
        if (model instanceof IPluginModelBase) {
            pluginBase = ((IPluginModelBase)model).getPluginBase();
        }
        if (model instanceof IBuildModel) {
            build = ((IBuildModel)model).getBuild();
        }
        try {
            int i = 0;
            while (i < elements.length) {
                IPluginElement e;
                Object element = elements[i];
                if (element instanceof IPluginImport) {
                    pluginBase.remove((IPluginImport)element);
                } else if (element instanceof IPluginLibrary) {
                    pluginBase.remove((IPluginLibrary)element);
                } else if (element instanceof IPluginExtensionPoint) {
                    pluginBase.remove((IPluginExtensionPoint)element);
                } else if (element instanceof IPluginExtension) {
                    pluginBase.remove((IPluginExtension)element);
                } else if (element instanceof IPluginElement) {
                    e = (IPluginElement)element;
                    IPluginObject parent = e.getParent();
                    if (parent instanceof PluginLibraryNode && e instanceof PluginElementNode) {
                        ((PluginLibraryNode)parent).removeContentFilter((PluginElementNode)e);
                    } else if (parent instanceof IPluginParent) {
                        ((IPluginParent)parent).remove((IPluginObject)e);
                    }
                } else if (element instanceof IBuildEntry) {
                    e = (IBuildEntry)element;
                    build.remove((IBuildEntry)e);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeAttributeChange(AttributeChangedEvent e, boolean undo) {
        PluginElement element = (PluginElement)e.getChangedObjects()[0];
        PluginAttribute att = (PluginAttribute)e.getChangedAttribute();
        Object oldValue = e.getOldValue();
        Object newValue = e.getNewValue();
        try {
            if (undo) {
                element.setAttribute(att.getName(), oldValue.toString());
            } else {
                element.setAttribute(att.getName(), newValue.toString());
            }
        }
        catch (CoreException ex) {
            PDEPlugin.logException(ex);
        }
    }

    private void executeChange(Object element, String propertyName, Object oldValue, Object newValue) {
        if (element instanceof PluginObject) {
            PluginObject pobj = (PluginObject)element;
            try {
                pobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        } else if (element instanceof BuildObject) {
            BuildObject bobj = (BuildObject)element;
            try {
                bobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        } else if (element instanceof PluginObjectNode) {
            PluginObjectNode node = (PluginObjectNode)element;
            String newString = newValue != null ? newValue.toString() : null;
            node.setXMLAttribute(propertyName, newString);
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 3) {
            IPluginObject obj;
            Object changedObject = event.getChangedObjects()[0];
            if (changedObject instanceof IPluginObject && !((obj = (IPluginObject)event.getChangedObjects()[0]) instanceof IPluginBase) && !obj.isInTheModel()) {
                return;
            }
            if (changedObject instanceof IBuildObject && !(obj = (IBuildObject)event.getChangedObjects()[0]).isInTheModel()) {
                return;
            }
        }
        super.modelChanged(event);
    }
}

