/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.metadata;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jst.jsf.common.metadata.internal.AbstractMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataChangeNotificationEvent;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataObserver;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IPathSensitiveMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataChangeNotificationEvent;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.core.internal.CompositeTagRegistryFactory;
import org.eclipse.jst.jsf.core.metadata.internal.INamespaceModelProvider;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletNamespaceMetaDataLocator
extends AbstractMetaDataLocator
implements IPathSensitiveMetaDataLocator,
ITagRegistry.ITagRegistryListener {
    private static final IContentType XHTML_CONTENTTYPE = Platform.getContentTypeManager().getContentType("org.eclipse.wst.html.core.htmlsource");
    private IProject _project;
    private ITagRegistry _reg;

    public List<IMetaDataSourceModelProvider> locateMetaDataModelProviders(String uri) {
        Namespace ns;
        ArrayList<IMetaDataSourceModelProvider> providers = new ArrayList<IMetaDataSourceModelProvider>();
        if (this._reg != null && (ns = this._reg.getTagLibrary(uri)) != null) {
            providers.add((IMetaDataSourceModelProvider)new NamespaceSourceModel(ns));
        }
        return providers;
    }

    public void startLocating() {
        CompositeTagRegistryFactory.TagRegistryIdentifier tagRegId = new CompositeTagRegistryFactory.TagRegistryIdentifier(this._project, XHTML_CONTENTTYPE);
        this._reg = CompositeTagRegistryFactory.getInstance().getRegistry(tagRegId);
        if (this._reg != null) {
            this._reg.addListener((ITagRegistry.ITagRegistryListener)this);
        }
    }

    public void stopLocating() {
        if (this._reg != null) {
            this._reg.removeListener((ITagRegistry.ITagRegistryListener)this);
            this._reg = null;
        }
    }

    public void setProjectContext(IProject project) {
        this._project = project;
    }

    public void registryChanged(ITagRegistry.TagRegistryChangeEvent changeEvent) {
        for (Namespace ns : changeEvent.getAffectedObjects()) {
            if (this.adaptTagRegistryEvent(changeEvent) == 1) continue;
            MetaDataChangeNotificationEvent mdEvent = new MetaDataChangeNotificationEvent((IMetaDataLocator)this, ns.getNSUri(), this.adaptTagRegistryEvent(changeEvent));
            this.fireEvent((IMetaDataChangeNotificationEvent)mdEvent);
        }
    }

    private int adaptTagRegistryEvent(ITagRegistry.TagRegistryChangeEvent event) {
        switch (event.getType()) {
            case ADDED_NAMESPACE: {
                return 1;
            }
            case REMOVED_NAMESPACE: 
            case REGISTRY_DISPOSED: {
                return 2;
            }
        }
        return 3;
    }

    private void fireEvent(final IMetaDataChangeNotificationEvent event) {
        SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                FaceletCorePlugin.log("Error while firing metadataChangeNotificationEvent", exception);
            }

            public void run() throws Exception {
                for (IMetaDataObserver observer : FaceletNamespaceMetaDataLocator.this.getObservers()) {
                    observer.notifyMetadataChanged(event);
                }
            }
        });
    }

    private class NamespaceSourceModel
    implements INamespaceModelProvider {
        private Namespace ns;
        private IMetaDataLocator locator;

        NamespaceSourceModel(Namespace ns) {
            this.ns = ns;
        }

        public Object getSourceModel() {
            return this.ns;
        }

        public IMetaDataLocator getLocator() {
            return this.locator;
        }

        public void setLocator(IMetaDataLocator locator) {
            this.locator = locator;
        }

        public Object getAdapter(Class klass) {
            return null;
        }

        public Namespace getNamespace() {
            return this.ns;
        }
    }
}

