/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.IComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.LevelDefiniton;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilter;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;
import org.eclipse.birt.data.engine.olap.query.view.AggregationRegisterTable;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.DrillCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.query.view.Relationship;
import org.eclipse.birt.data.engine.olap.util.CubeAggrDefn;
import org.eclipse.birt.data.engine.olap.util.CubeAggrDefnOnMeasure;
import org.eclipse.birt.data.engine.olap.util.CubeRunningNestAggrDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.filter.JSFacttableFilterEvalHelper;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeQueryDefinitionUtil {
    static CalculatedMember[] getCalculatedMembers(ICubeQueryDefinition queryDefn, Scriptable scope, Map measureMapping, ScriptContext cx) throws DataException {
        CubeAggrDefn[] cubeAggrs = OlapExpressionUtil.getAggrDefns(queryDefn.getBindings());
        CubeQueryDefinitionUtil.populateMeasureFromBinding(queryDefn, cx);
        CubeQueryDefinitionUtil.populateMeasureFromFilter(queryDefn, cx);
        CubeQueryDefinitionUtil.populateMeasureFromSort(queryDefn, cx);
        CalculatedMember[] calculatedMembers1 = CubeQueryDefinitionUtil.extractMeasure(queryDefn, measureMapping);
        int startRsId = calculatedMembers1.length == 0 ? 0 : 1;
        CalculatedMember[] calculatedMembers2 = CubeQueryDefinitionUtil.createCalculatedMembersByAggrOnList(startRsId, cubeAggrs, scope, cx);
        return CubeQueryDefinitionUtil.uniteCalculatedMember(calculatedMembers1, calculatedMembers2);
    }

    private static CalculatedMember[] extractMeasure(ICubeQueryDefinition queryDefn, Map measureMapping) throws DataException {
        List measureList = queryDefn.getMeasures();
        if (measureList == null) {
            return new CalculatedMember[0];
        }
        List measureAggrOns = CubeQueryDefinitionUtil.populateMeasureAggrOns(queryDefn);
        List unreferencedMeasures = CubeQueryDefinitionUtil.getUnreferencedMeasures(queryDefn, measureList, measureMapping, measureAggrOns);
        CalculatedMember[] calculatedMembers1 = new CalculatedMember[unreferencedMeasures.size()];
        int index = 0;
        for (MeasureDefinition measureDefn : unreferencedMeasures) {
            String innerName = OlapExpressionUtil.createMeasureCalculateMemeberName(measureDefn.getName());
            measureMapping.put(measureDefn.getName(), innerName);
            calculatedMembers1[index] = new CalculatedMember(new CubeAggrDefnOnMeasure(innerName, measureDefn.getName(), measureAggrOns, CubeQueryDefinitionUtil.adaptAggrFunction(measureDefn), null, null), 0);
            ++index;
        }
        return calculatedMembers1;
    }

    public static CalculatedMember[] createCalculatedMembersByAggrOnList(int startRsId, CubeAggrDefn[] cubeAggrs, Scriptable scope, ScriptContext cx) throws DataException {
        if (cubeAggrs == null) {
            return new CalculatedMember[0];
        }
        assert (startRsId >= 0);
        int preparedRsId = startRsId;
        CalculatedMember[] result = new CalculatedMember[cubeAggrs.length];
        ArrayList<CalculatedMember> withDistinctRsIds = new ArrayList<CalculatedMember>();
        int index = 0;
        CubeAggrDefn[] cubeAggrDefnArray = cubeAggrs;
        int n = cubeAggrs.length;
        int n2 = 0;
        while (n2 < n) {
            CubeAggrDefn cubeAggrDefn = cubeAggrDefnArray[n2];
            int id = CubeQueryDefinitionUtil.getResultSetIndex(withDistinctRsIds, cubeAggrDefn.getAggrLevelsInAggregationResult());
            if (id == -1) {
                result[index] = new CalculatedMember(cubeAggrDefn, preparedRsId);
                withDistinctRsIds.add(result[index]);
                ++preparedRsId;
            } else {
                result[index] = new CalculatedMember(cubeAggrDefn, id);
            }
            if (cubeAggrDefn.getFilter() != null) {
                JSFacttableFilterEvalHelper filterEvalHelper = new JSFacttableFilterEvalHelper(scope, cx, new FilterDefinition(cubeAggrDefn.getFilter()), null, null);
                result[index].setFilterEvalHelper(filterEvalHelper);
            }
            ++index;
            ++n2;
        }
        return result;
    }

    public static boolean isRunnnigAggr(CubeAggrDefn cubeAggr) throws DataException {
        return CubeQueryDefinitionUtil.isRunnnigAggr(cubeAggr.getAggrName());
    }

    public static boolean isRunnnigAggr(String aggrFunc) throws DataException {
        IAggrFunction af = AggregationManager.getInstance().getAggregation(aggrFunc);
        return af != null && af.getType() == 1;
    }

    public static ICubeQueryDefinition[] getCubeQueryFromDrills(ICubeQueryDefinition query, ICube cube, int edgeType) throws DataException {
        ArrayList<ICubeQueryDefinition> queryDefinition = new ArrayList<ICubeQueryDefinition>();
        IEdgeDefinition edge = query.getEdge(edgeType);
        if (edge != null && edge.getDrillFilter().size() > 0) {
            IEdgeDrillFilter rowDrill = null;
            IEdgeDrillFilter columnDrill = null;
            int i = 0;
            while (i < edge.getDrillFilter().size()) {
                if (edgeType == 2) {
                    columnDrill = edge.getDrillFilter().get(i);
                } else {
                    rowDrill = edge.getDrillFilter().get(i);
                }
                queryDefinition.add(CubeQueryDefinitionUtil.cloneCubeQueryDefinition(query, columnDrill, rowDrill, cube));
                ++i;
            }
        }
        ICubeQueryDefinition[] drillQuery = new ICubeQueryDefinition[queryDefinition.size()];
        int i = 0;
        while (i < drillQuery.length) {
            drillQuery[i] = (ICubeQueryDefinition)queryDefinition.get(i);
            ++i;
        }
        return drillQuery;
    }

    public static ICubeQueryDefinition[] getCrossCubeQueryFromDrills(ICubeQueryDefinition query, ICube cube) throws DataException {
        IEdgeDefinition columnEdge = query.getEdge(2);
        IEdgeDefinition rowEdge = query.getEdge(1);
        ArrayList<ICubeQueryDefinition> queryDefinition = new ArrayList<ICubeQueryDefinition>();
        if (columnEdge != null && columnEdge.getDrillFilter().size() > 0 && rowEdge != null && rowEdge.getDrillFilter().size() > 0) {
            IEdgeDrillFilter rowDrill = null;
            IEdgeDrillFilter columnDrill = null;
            int i = 0;
            while (i < columnEdge.getDrillFilter().size()) {
                columnDrill = columnEdge.getDrillFilter().get(i);
                int j = 0;
                while (j < rowEdge.getDrillFilter().size()) {
                    rowDrill = rowEdge.getDrillFilter().get(j);
                    queryDefinition.add(CubeQueryDefinitionUtil.cloneCubeQueryDefinition(query, columnDrill, rowDrill, cube));
                    ++j;
                }
                ++i;
            }
        }
        ICubeQueryDefinition[] drillQuery = new ICubeQueryDefinition[queryDefinition.size()];
        int i = 0;
        while (i < drillQuery.length) {
            drillQuery[i] = (ICubeQueryDefinition)queryDefinition.get(i);
            ++i;
        }
        return drillQuery;
    }

    private static ICubeQueryDefinition cloneCubeQueryDefinition(ICubeQueryDefinition query, IEdgeDrillFilter columnDrill, IEdgeDrillFilter rowDrill, ICube cube) throws DataException {
        DrillCubeQueryDefinition cloneQuery = null;
        if (query != null) {
            IMeasureDefinition cloneMeasure;
            IMeasureDefinition measure;
            cloneQuery = new DrillCubeQueryDefinition(query.getName());
            if (query.getEdge(2) != null) {
                if (columnDrill != null) {
                    cloneQuery.setTupleOnColumn(columnDrill.getTuple());
                }
                CubeQueryDefinitionUtil.cloneEdgeDefinition(cloneQuery, query.getEdge(2), 2, columnDrill, cube);
            }
            if (query.getEdge(1) != null) {
                if (rowDrill != null) {
                    cloneQuery.setTupleOnRow(rowDrill.getTuple());
                }
                CubeQueryDefinitionUtil.cloneEdgeDefinition(cloneQuery, query.getEdge(1), 1, rowDrill, cube);
            }
            int i = 0;
            while (i < query.getMeasures().size()) {
                measure = (IMeasureDefinition)query.getMeasures().get(i);
                cloneMeasure = cloneQuery.createMeasure(measure.getName());
                cloneMeasure.setAggrFunction(measure.getAggrFunction());
                ++i;
            }
            i = 0;
            while (i < query.getComputedMeasures().size()) {
                measure = (IComputedMeasureDefinition)query.getComputedMeasures().get(i);
                cloneMeasure = cloneQuery.createComputedMeasure(measure.getName(), measure.getType(), measure.getExpression());
                cloneMeasure.setAggrFunction(measure.getAggrFunction());
                ++i;
            }
            List levelDefnOnColumn = new ArrayList();
            List levelDefnOnRow = new ArrayList();
            if (columnDrill != null) {
                levelDefnOnColumn = CubeQueryDefinitionUtil.findLevelExpressionFromQuery(query.getEdge(2), columnDrill, cube);
            }
            if (rowDrill != null) {
                levelDefnOnRow = CubeQueryDefinitionUtil.findLevelExpressionFromQuery(query.getEdge(1), rowDrill, cube);
            }
            int i2 = 0;
            while (i2 < query.getBindings().size()) {
                IBinding binding = (IBinding)query.getBindings().get(i2);
                if (binding.getAggrFunction() != null) {
                    List dimLevelOnColumn = CubeQueryDefinitionUtil.getReferenceDimLevelOnEdge(query, 2);
                    List dimLevelOnRow = CubeQueryDefinitionUtil.getReferenceDimLevelOnEdge(query, 1);
                    Binding newBinding = new Binding(binding.getBindingName(), binding.getExpression());
                    newBinding.setDataType(binding.getDataType());
                    newBinding.setAggrFunction(binding.getAggrFunction());
                    newBinding.setDisplayName(binding.getDisplayName());
                    newBinding.setExportable(binding.exportable());
                    newBinding.setFilter(newBinding.getFilter());
                    int k = 0;
                    while (k < binding.getArguments().size()) {
                        newBinding.addArgument((IBaseExpression)binding.getArguments().get(k));
                        ++k;
                    }
                    List aggrOns = binding.getAggregatOns();
                    if (aggrOns != null && !aggrOns.isEmpty()) {
                        boolean columnExist = false;
                        boolean rowExist = false;
                        boolean detailLevelOnColumn = CubeQueryDefinitionUtil.isGrandTotalOnEdge(aggrOns, dimLevelOnColumn);
                        boolean detailLevelOnRow = CubeQueryDefinitionUtil.isGrandTotalOnEdge(aggrOns, dimLevelOnRow);
                        if ((detailLevelOnColumn || detailLevelOnRow) && (detailLevelOnColumn && columnDrill != null || detailLevelOnRow && rowDrill != null)) {
                            int k2 = 0;
                            while (k2 < aggrOns.size()) {
                                int t;
                                String dimensionNameOnRow;
                                String aggrExpr = aggrOns.get(k2).toString();
                                DimLevel target = OlapExpressionUtil.getTargetDimLevel(aggrExpr);
                                String dimensionNameOnColumn = columnDrill != null ? columnDrill.getTargetHierarchy().getDimension().getName() : null;
                                String string = dimensionNameOnRow = rowDrill != null ? rowDrill.getTargetHierarchy().getDimension().getName() : null;
                                if (!columnExist && target.getDimensionName().equals(dimensionNameOnColumn)) {
                                    if (!detailLevelOnColumn) {
                                        newBinding.addAggregateOn(aggrExpr);
                                    } else {
                                        columnExist = true;
                                        t = 0;
                                        while (t < levelDefnOnColumn.size()) {
                                            newBinding.addAggregateOn((String)levelDefnOnColumn.get(t));
                                            ++t;
                                        }
                                    }
                                } else if (!rowExist && target.getDimensionName().equals(dimensionNameOnRow)) {
                                    if (!detailLevelOnRow) {
                                        newBinding.addAggregateOn(aggrExpr);
                                    } else {
                                        rowExist = true;
                                        t = 0;
                                        while (t < levelDefnOnRow.size()) {
                                            newBinding.addAggregateOn((String)levelDefnOnRow.get(t));
                                            ++t;
                                        }
                                    }
                                } else if (!target.getDimensionName().equals(dimensionNameOnColumn) && !target.getDimensionName().equals(dimensionNameOnRow)) {
                                    newBinding.addAggregateOn(aggrExpr);
                                }
                                ++k2;
                            }
                            cloneQuery.addBinding(newBinding);
                        }
                    }
                } else {
                    cloneQuery.addBinding((IBinding)query.getBindings().get(i2));
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < query.getFilters().size()) {
                if (CubeQueryDefinitionUtil.canAddFilterToDrill(query, rowDrill, columnDrill, i2)) {
                    cloneQuery.addFilter((IFilterDefinition)query.getFilters().get(i2));
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < query.getSorts().size()) {
                cloneQuery.addSort((ISortDefinition)query.getSorts().get(i2));
                ++i2;
            }
        }
        return cloneQuery;
    }

    private static boolean canAddFilterToDrill(ICubeQueryDefinition query, IEdgeDrillFilter rowDrill, IEdgeDrillFilter columnDrill, int i) {
        List<ILevelDefinition> levelDefinition;
        String drillTargetLevel;
        String hierarchyName;
        int p;
        List<IDimensionDefinition> columnEdgeDimensions = null;
        if (query.getEdge(2) != null) {
            columnEdgeDimensions = query.getEdge(2).getDimensions();
        }
        List<IDimensionDefinition> rowEdgeDimensions = null;
        if (query.getEdge(1) != null) {
            rowEdgeDimensions = query.getEdge(1).getDimensions();
        }
        if (!(query.getFilters().get(i) instanceof ICubeFilterDefinition)) {
            return true;
        }
        ICubeFilterDefinition filter = (ICubeFilterDefinition)query.getFilters().get(i);
        if (filter.getTargetLevel() == null) {
            return false;
        }
        int filterIndex = -1;
        int rowDrillIndex = -1;
        int columnDrillIndex = -1;
        int edgeTag = -1;
        boolean canAddFilter = false;
        if (rowEdgeDimensions != null && rowDrill != null) {
            p = 0;
            while (p < rowEdgeDimensions.size()) {
                IDimensionDefinition rowEdgeDimension = rowEdgeDimensions.get(p);
                hierarchyName = rowEdgeDimension.getHierarchy().get(0).getName();
                if (hierarchyName.equals(filter.getTargetLevel().getHierarchy().getName())) {
                    filterIndex = p;
                    edgeTag = 1;
                }
                if (rowDrill.getTargetHierarchy().getName().equals(hierarchyName)) {
                    rowDrillIndex = p;
                }
                ++p;
            }
        }
        if (columnEdgeDimensions != null && columnDrill != null) {
            p = 0;
            while (p < columnEdgeDimensions.size()) {
                IDimensionDefinition columnEdgeDimension = columnEdgeDimensions.get(p);
                hierarchyName = columnEdgeDimension.getHierarchy().get(0).getName();
                if (hierarchyName.equals(filter.getTargetLevel().getHierarchy().getName())) {
                    filterIndex = p;
                    edgeTag = 2;
                }
                if (columnDrill.getTargetHierarchy().getName().equals(hierarchyName)) {
                    columnDrillIndex = p;
                }
                ++p;
            }
        }
        if (edgeTag == 1) {
            if (rowDrillIndex < filterIndex) {
                canAddFilter = false;
            } else if (rowDrillIndex > filterIndex) {
                canAddFilter = true;
            } else {
                String filterTargetLevel = filter.getTargetLevel().getName();
                drillTargetLevel = rowDrill.getTargetLevelName();
                levelDefinition = filter.getTargetLevel().getHierarchy().getLevels();
                int drillLevelIndex = 0;
                int filterLevelIndex = 0;
                int j = 0;
                while (j < levelDefinition.size()) {
                    ILevelDefinition level = levelDefinition.get(j);
                    if (level.getName().equals(drillTargetLevel)) {
                        drillLevelIndex = j;
                    }
                    if (level.getName().equals(filterTargetLevel)) {
                        filterLevelIndex = j;
                    }
                    ++j;
                }
                if (drillLevelIndex >= filterLevelIndex) {
                    canAddFilter = true;
                }
            }
        } else if (edgeTag == 2) {
            if (columnDrillIndex < filterIndex) {
                canAddFilter = false;
            } else if (columnDrillIndex > filterIndex) {
                canAddFilter = true;
            } else {
                String filterTargetLevel = filter.getTargetLevel().getName();
                drillTargetLevel = columnDrill.getTargetLevelName();
                levelDefinition = filter.getTargetLevel().getHierarchy().getLevels();
                int drillLevelIndex = 0;
                int filterLevelIndex = 0;
                int j = 0;
                while (j < levelDefinition.size()) {
                    ILevelDefinition level = levelDefinition.get(j);
                    if (level.getName().equals(drillTargetLevel)) {
                        drillLevelIndex = j;
                    }
                    if (level.getName().equals(filterTargetLevel)) {
                        filterLevelIndex = j;
                    }
                    ++j;
                }
                if (drillLevelIndex >= filterLevelIndex) {
                    canAddFilter = true;
                }
            }
        }
        return canAddFilter;
    }

    private static boolean isGrandTotalOnEdge(List aggrOns, List dimLevels) throws DataException {
        boolean flag = false;
        int i = 0;
        while (i < aggrOns.size()) {
            String aggrExpr = aggrOns.get(i).toString();
            DimLevel target = OlapExpressionUtil.getTargetDimLevel(aggrExpr);
            if (!dimLevels.isEmpty() && dimLevels.get(dimLevels.size() - 1).equals(target)) {
                flag = true;
                break;
            }
            ++i;
        }
        return flag;
    }

    private static void cloneEdgeDefinition(DrillCubeQueryDefinition cloneQuery, IEdgeDefinition edge, int type, IEdgeDrillFilter drill, ICube cube) throws DataException {
        IEdgeDefinition cloneEdge = cloneQuery.createEdge(type);
        Iterator<IDimensionDefinition> dimension = edge.getDimensions().iterator();
        ArrayList<ILevelDefinition> levelDefnList = new ArrayList<ILevelDefinition>();
        while (dimension.hasNext()) {
            IDimensionDefinition dim = dimension.next();
            IDimensionDefinition cloneDim = cloneEdge.createDimension(dim.getName());
            block3: for (IHierarchyDefinition hierarchy : dim.getHierarchy()) {
                IHierarchyDefinition cloneHier = cloneDim.createHierarchy(hierarchy.getName());
                if (drill != null && hierarchy.getName().equals(drill.getTargetHierarchy().getName())) {
                    IHierarchy cubeHierarchy = CubeQueryDefinitionUtil.findHierarchyFromCube(cube, hierarchy);
                    ILevel[] iLevelArray = cubeHierarchy.getLevels();
                    int n = iLevelArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILevelDefinition cloneLevel;
                        ILevel cubeLevel = iLevelArray[n2];
                        if (cubeLevel.getName().equals(drill.getTargetLevelName())) {
                            cloneLevel = cloneHier.createLevel(cubeLevel.getName());
                            levelDefnList.add(cloneLevel);
                            continue block3;
                        }
                        cloneLevel = cloneHier.createLevel(cubeLevel.getName());
                        levelDefnList.add(cloneLevel);
                        ++n2;
                    }
                    continue;
                }
                for (ILevelDefinition level : hierarchy.getLevels()) {
                    ILevelDefinition cloneLevel = cloneHier.createLevel(level.getName());
                    levelDefnList.add(cloneLevel);
                }
            }
        }
        if (drill != null) {
            Iterator<Object[]> members = drill.getTuple().iterator();
            Iterator levels = levelDefnList.iterator();
            ArrayList<Object[]> qulifiedTuple = new ArrayList<Object[]>();
            while (members.hasNext() && levels.hasNext()) {
                Object[] key = members.next();
                if (key == null || key.length <= 0 || key[0] == null) continue;
                ILevelDefinition level = (ILevelDefinition)levels.next();
                int dataType = CubeQueryDefinitionUtil.getLevelDataType(level, cube);
                Object[] qualifiedKey = new Object[key.length];
                Object[][] multipleKey = new Object[key.length][];
                int i = 0;
                while (i < key.length) {
                    try {
                        Object value;
                        qualifiedKey[i] = value = DataTypeUtil.convert((Object)key[i], (int)dataType);
                        multipleKey[i] = new Object[]{value};
                    }
                    catch (BirtException birtException) {}
                    ++i;
                }
                qulifiedTuple.add(qualifiedKey);
                ISelection selection = SelectionFactory.createMutiKeySelection(multipleKey);
                cloneQuery.addLevelFilter(new LevelFilter(new DimLevel(level), new ISelection[]{selection}));
            }
            if (type == 2) {
                cloneQuery.setTupleOnColumn(qulifiedTuple);
            } else {
                cloneQuery.setTupleOnRow(qulifiedTuple);
            }
            drill.setTuple(qulifiedTuple);
        }
    }

    private static int getLevelDataType(ILevelDefinition level, ICube cube) {
        IHierarchy hierarchy = CubeQueryDefinitionUtil.findHierarchyFromCube(cube, level.getHierarchy());
        int dataType = 0;
        if (hierarchy != null) {
            ILevel[] levelArray = hierarchy.getLevels();
            int i = 0;
            while (i < levelArray.length) {
                if (levelArray[i].getName().equals(level.getName())) {
                    dataType = levelArray[i].getKeyDataType(level.getName());
                    break;
                }
                ++i;
            }
        }
        return dataType;
    }

    private static List findLevelExpressionFromQuery(IEdgeDefinition edge, IEdgeDrillFilter drill, ICube cube) throws DataException {
        ArrayList<String> levelList = new ArrayList<String>();
        List<IDimensionDefinition> dimensionList = edge.getDimensions();
        int i = 0;
        while (i < dimensionList.size()) {
            IDimensionDefinition dim = dimensionList.get(i);
            List<IHierarchyDefinition> hierarchyList = dim.getHierarchy();
            IHierarchyDefinition hier = hierarchyList.get(0);
            if (hier.getName().equals(drill.getTargetHierarchy().getName())) {
                IHierarchy cubeHierarchy = CubeQueryDefinitionUtil.findHierarchyFromCube(cube, drill.getTargetHierarchy());
                ILevel[] iLevelArray = cubeHierarchy.getLevels();
                int n = iLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILevel cubeLevel = iLevelArray[n2];
                    if (cubeLevel.getName().equals(drill.getTargetLevelName())) {
                        levelList.add(ExpressionUtil.createJSDimensionExpression((String)dim.getName(), (String)cubeLevel.getName()));
                        break;
                    }
                    levelList.add(ExpressionUtil.createJSDimensionExpression((String)dim.getName(), (String)cubeLevel.getName()));
                    ++n2;
                }
            } else {
                int k = 0;
                while (k < hier.getLevels().size()) {
                    ILevelDefinition level = hier.getLevels().get(k);
                    levelList.add(ExpressionUtil.createJSDimensionExpression((String)dim.getName(), (String)level.getName()));
                    ++k;
                }
            }
            ++i;
        }
        return levelList;
    }

    private static IHierarchy findHierarchyFromCube(ICube cube, IHierarchyDefinition hierarchy) {
        IDimension[] iDimensionArray = cube.getDimesions();
        int n = iDimensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDimension dim = iDimensionArray[n2];
            if (dim.getName().equals(hierarchy.getDimension().getName()) && dim.getHierarchy().getName().equals(hierarchy.getName())) {
                return dim.getHierarchy();
            }
            ++n2;
        }
        return null;
    }

    public static CalculatedMember[] addCalculatedMembers(CubeAggrDefn[] cubeAggrs, AggregationRegisterTable manager, Scriptable scope, ScriptContext cx) throws DataException {
        if (cubeAggrs == null) {
            return new CalculatedMember[0];
        }
        CalculatedMember[] result = new CalculatedMember[cubeAggrs.length];
        int newRsId = manager.getBasedRsIndex() + 1;
        CalculatedMember newCm = null;
        int index = 0;
        CubeAggrDefn[] cubeAggrDefnArray = cubeAggrs;
        int n = cubeAggrs.length;
        int n2 = 0;
        while (n2 < n) {
            CubeAggrDefn cubeAggrDefn = cubeAggrDefnArray[n2];
            int id = -1;
            if (!CubeQueryDefinitionUtil.isRunnnigAggr(cubeAggrDefn)) {
                CalculatedMember[] calculatedMemberArray = manager.getCalculatedMembers();
                int n3 = calculatedMemberArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CalculatedMember cm = calculatedMemberArray[n4];
                    if (cm.getCubeAggrDefn().getAggrLevelsInAggregationResult().equals(cubeAggrDefn.getAggrLevelsInAggregationResult())) {
                        id = cm.getRsID();
                        break;
                    }
                    ++n4;
                }
            }
            if (id == -1) {
                newCm = new CalculatedMember(cubeAggrDefn, newRsId);
                ++newRsId;
            } else {
                newCm = new CalculatedMember(cubeAggrDefn, id);
            }
            if (cubeAggrDefn.getFilter() != null) {
                JSFacttableFilterEvalHelper filterEvalHelper = new JSFacttableFilterEvalHelper(scope, cx, new FilterDefinition(cubeAggrDefn.getFilter()), null, null);
                newCm.setFilterEvalHelper(filterEvalHelper);
            }
            manager.addCalculatedMembersFromCubeOperation(new CalculatedMember[]{newCm});
            result[index++] = newCm;
            ++n2;
        }
        return result;
    }

    public static CalculatedMember[] uniteCalculatedMember(CalculatedMember[] array1, CalculatedMember[] array2) {
        assert (array1 != null && array2 != null);
        int size = array1.length + array2.length;
        CalculatedMember[] result = new CalculatedMember[size];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static AggregationDefinition[] createAggregationDefinitons(CalculatedMember[] calculatedMembers, ICubeQueryDefinition query, Scriptable scope, ScriptContext cx) throws DataException {
        if (calculatedMembers == null) {
            return new AggregationDefinition[0];
        }
        ArrayList<AggregationDefinition> result = new ArrayList<AggregationDefinition>();
        HashSet<Integer> rsIDSet = new HashSet<Integer>();
        int i = 0;
        while (i < calculatedMembers.length) {
            if (!rsIDSet.contains(calculatedMembers[i].getRsID())) {
                List<CalculatedMember> list = CubeQueryDefinitionUtil.getCalculatedMemberWithSameRSId(calculatedMembers, i);
                AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[list.size()];
                int index = 0;
                while (index < list.size()) {
                    CubeRunningNestAggrDefn crnad;
                    String[] dimInfo = list.get(index).getCubeAggrDefn().getFirstArgumentInfo();
                    String dimName = null;
                    String levelName = null;
                    String attributeName = null;
                    DimLevel dimLevel = null;
                    if (dimInfo != null && dimInfo.length == 3) {
                        dimName = dimInfo[0];
                        levelName = dimInfo[1];
                        attributeName = dimInfo[2];
                        dimLevel = new DimLevel(dimName, levelName);
                    }
                    funcitons[index] = new AggregationFunctionDefinition(list.get(index).getCubeAggrDefn().getName(), list.get(index).getCubeAggrDefn().getMeasure(), dimLevel, attributeName, list.get(index).getCubeAggrDefn().getAggrName(), list.get(index).getFilterEvalHelper());
                    CubeAggrDefn cad = list.get(index).getCubeAggrDefn();
                    if (cad instanceof CubeRunningNestAggrDefn && (crnad = (CubeRunningNestAggrDefn)cad).getNotLevelArguments() != null && !crnad.getNotLevelArguments().isEmpty()) {
                        IScriptExpression se = crnad.getNotLevelArguments().get(0);
                        Object argumentValue = ScriptEvalUtil.evalExpr(se, cx.newContext((Object)scope), ScriptExpression.defaultID, 0);
                        funcitons[index].setParaValue(argumentValue);
                    }
                    ++index;
                }
                DimLevel[] levels = new DimLevel[calculatedMembers[i].getCubeAggrDefn().getAggrLevelsInDefinition().size()];
                int[] sortType = new int[levels.length];
                int index2 = 0;
                while (index2 < levels.length) {
                    Object obj = calculatedMembers[i].getCubeAggrDefn().getAggrLevelsInDefinition().get(index2);
                    levels[index2] = (DimLevel)obj;
                    sortType[index2] = CubeQueryDefinitionUtil.getSortDirection(levels[index2], query);
                    ++index2;
                }
                rsIDSet.add(calculatedMembers[i].getRsID());
                result.add(new AggregationDefinition(levels, sortType, funcitons));
            }
            ++i;
        }
        return result.toArray(new AggregationDefinition[0]);
    }

    public static int getSortDirection(DimLevel level, ICubeQueryDefinition query) throws DataException {
        if (query.getSorts() != null && !query.getSorts().isEmpty()) {
            int i = 0;
            while (i < query.getSorts().size()) {
                ISortDefinition sortDfn = (ISortDefinition)query.getSorts().get(i);
                DimLevel info = null;
                if (sortDfn.getExpression() == null) {
                    String colName = sortDfn.getColumn();
                    info = CubeQueryDefinitionUtil.getDimLevelByBindingName(colName, query.getBindings());
                    if (level.equals(info)) {
                        return sortDfn.getSortDirection();
                    }
                } else {
                    String expr = null;
                    expr = sortDfn.getExpression().getText();
                    info = CubeQueryDefinitionUtil.getDimLevel(expr, query.getBindings());
                    if (level.equals(info)) {
                        return sortDfn.getSortDirection();
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    private static DimLevel getDimLevel(String expr, List bindings) throws DataException {
        String bindingName = OlapExpressionUtil.getBindingName(expr);
        DimLevel dimLevel = CubeQueryDefinitionUtil.getDimLevelByBindingName(bindingName, bindings);
        if (dimLevel != null) {
            return null;
        }
        if (!OlapExpressionUtil.isReferenceToDimLevel(expr)) {
            return null;
        }
        return OlapExpressionUtil.getTargetDimLevel(expr);
    }

    private static DimLevel getDimLevelByBindingName(String bindingName, List bindings) throws DataException {
        if (bindingName != null) {
            int j = 0;
            while (j < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(j);
                if (binding.getBindingName().equals(bindingName)) {
                    if (!(binding.getExpression() instanceof IScriptExpression)) {
                        return null;
                    }
                    return CubeQueryDefinitionUtil.getDimLevel(((IScriptExpression)binding.getExpression()).getText(), bindings);
                }
                ++j;
            }
        }
        return null;
    }

    private static List<CalculatedMember> getCalculatedMemberWithSameRSId(CalculatedMember[] calMember, int index) {
        CalculatedMember member = calMember[index];
        ArrayList<CalculatedMember> list = new ArrayList<CalculatedMember>();
        list.add(member);
        int i = index + 1;
        while (i < calMember.length) {
            if (calMember[i].getRsID() == member.getRsID()) {
                list.add(calMember[i]);
            }
            ++i;
        }
        return list;
    }

    static int getLevelIndex(ICubeQueryDefinition queryDefn, String levelExpr, int type) throws DataException {
        int index = -1;
        DimLevel dimLevel = OlapExpressionUtil.getTargetDimLevel(levelExpr);
        IEdgeDefinition edgeDefn = queryDefn.getEdge(type);
        for (IDimensionDefinition dimDefn : edgeDefn.getDimensions()) {
            for (IHierarchyDefinition hierarchyDefn : dimDefn.getHierarchy()) {
                int i = 0;
                while (i < hierarchyDefn.getLevels().size()) {
                    ++index;
                    ILevelDefinition levelDefn = hierarchyDefn.getLevels().get(i);
                    if (dimDefn.getName().equals(dimLevel.getDimensionName()) && levelDefn.getName().equals(dimLevel.getLevelName())) {
                        return index;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    private static String adaptAggrFunction(MeasureDefinition measureDefn) {
        return measureDefn.getAggrFunction() == null ? "SUM" : measureDefn.getAggrFunction();
    }

    private static List getUnreferencedMeasures(ICubeQueryDefinition queryDefn, List measureList, Map measureMapping, List measureAggrOns) throws DataException {
        ArrayList<MeasureDefinition> result = new ArrayList<MeasureDefinition>();
        List bindings = queryDefn.getBindings();
        for (MeasureDefinition measure : measureList) {
            IBinding referenceBinding = CubeQueryDefinitionUtil.getMeasureDirectReferenceBinding(measure, bindings, measureAggrOns);
            if (referenceBinding != null) {
                measureMapping.put(measure.getName(), referenceBinding.getBindingName());
                continue;
            }
            result.add(measure);
        }
        return result;
    }

    private static IBinding getMeasureDirectReferenceBinding(MeasureDefinition measure, List bindings, List measureAggrOns) throws DataException {
        for (IBinding binding : bindings) {
            IBaseExpression expression;
            String funcName;
            String aggrFunction;
            if (binding.getAggregatOns().size() != measureAggrOns.size() || !(aggrFunction = CubeQueryDefinitionUtil.adaptAggrFunction(measure)).equals(funcName = binding.getAggrFunction()) || !((expression = binding.getExpression()) instanceof IScriptExpression)) continue;
            IScriptExpression expr = (IScriptExpression)expression;
            String measureName = OlapExpressionUtil.getMeasure(expr.getText());
            if (!measure.getName().equals(measureName)) continue;
            int t = 0;
            while (t < measureAggrOns.size()) {
                DimLevel dimLevel = OlapExpressionUtil.getTargetDimLevel(binding.getAggregatOns().get(t).toString());
                if (!dimLevel.equals(measureAggrOns.get(t))) break;
                ++t;
            }
            if (t != measureAggrOns.size()) continue;
            return binding;
        }
        return null;
    }

    private static void populateMeasureFromSort(ICubeQueryDefinition queryDefn, ScriptContext cx) throws DataException {
        int i = 0;
        while (i < queryDefn.getSorts().size()) {
            CubeQueryDefinitionUtil.createRelationalMeasures(queryDefn, ((ISortDefinition)queryDefn.getSorts().get(i)).getExpression(), cx);
            ++i;
        }
    }

    private static void populateMeasureFromFilter(ICubeQueryDefinition queryDefn, ScriptContext cx) throws DataException {
        int i = 0;
        while (i < queryDefn.getFilters().size()) {
            CubeQueryDefinitionUtil.createRelationalMeasures(queryDefn, ((IFilterDefinition)queryDefn.getFilters().get(i)).getExpression(), cx);
            ++i;
        }
    }

    private static void populateMeasureFromBinding(ICubeQueryDefinition queryDefn, ScriptContext cx) throws DataException {
        int i = 0;
        while (i < queryDefn.getBindings().size()) {
            CubeQueryDefinitionUtil.createRelationalMeasures(queryDefn, ((IBinding)queryDefn.getBindings().get(i)).getExpression(), cx);
            ++i;
        }
    }

    private static List createRelationalMeasures(ICubeQueryDefinition queryDefn, IBaseExpression expression, ScriptContext cx) throws DataException {
        ArrayList<IMeasureDefinition> measures = new ArrayList<IMeasureDefinition>();
        List exprTextList = CubeQueryDefinitionUtil.getExprTextList(expression);
        int i = 0;
        while (i < exprTextList.size()) {
            String exprText = (String)exprTextList.get(i);
            String measureName = OlapExpressionCompiler.getReferencedScriptObject(exprText, "measure");
            if (measureName != null && measureName.trim().length() > 0) {
                List existMeasures = queryDefn.getMeasures();
                boolean exist = false;
                int j = 0;
                while (j < existMeasures.size()) {
                    if (((IMeasureDefinition)existMeasures.get(j)).getName().equals(measureName)) {
                        exist = true;
                        break;
                    }
                    ++j;
                }
                if (!exist) {
                    measures.add(queryDefn.createMeasure(measureName));
                }
            }
            ++i;
        }
        return measures;
    }

    private static List getExprTextList(IBaseExpression expression) {
        ArrayList<String> textList = new ArrayList<String>();
        if (expression instanceof IScriptExpression) {
            textList.add(((IScriptExpression)expression).getText());
        } else if (expression instanceof IExpressionCollection) {
            List exprList = (List)((IExpressionCollection)expression).getExpressions();
            int i = 0;
            while (i < exprList.size()) {
                IBaseExpression baseExpr = (IBaseExpression)exprList.get(i);
                textList.addAll(CubeQueryDefinitionUtil.getExprTextList(baseExpr));
                ++i;
            }
        } else if (expression instanceof IConditionalExpression) {
            textList.add(((IConditionalExpression)expression).getExpression().getText());
            textList.addAll(CubeQueryDefinitionUtil.getExprTextList(((IConditionalExpression)expression).getOperand1()));
            textList.addAll(CubeQueryDefinitionUtil.getExprTextList(((IConditionalExpression)expression).getOperand2()));
        }
        return textList;
    }

    public static List populateMeasureAggrOns(ICubeQueryDefinition queryDefn) {
        ArrayList<DimLevel> levelList = new ArrayList<DimLevel>();
        ILevelDefinition[] rowLevels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(1));
        ILevelDefinition[] columnLevels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(2));
        ILevelDefinition[] pageLevels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(3));
        int i = 0;
        while (i < rowLevels.length) {
            levelList.add(new DimLevel(rowLevels[i]));
            ++i;
        }
        i = 0;
        while (i < columnLevels.length) {
            levelList.add(new DimLevel(columnLevels[i]));
            ++i;
        }
        i = 0;
        while (i < pageLevels.length) {
            levelList.add(new DimLevel(pageLevels[i]));
            ++i;
        }
        return levelList;
    }

    private static List getReferenceDimLevelOnEdge(ICubeQueryDefinition queryDefn, int type) {
        ArrayList<DimLevel> levelList = new ArrayList<DimLevel>();
        ILevelDefinition[] rowLevels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(type));
        int i = 0;
        while (i < rowLevels.length) {
            levelList.add(new DimLevel(rowLevels[i]));
            ++i;
        }
        return levelList;
    }

    private static int getResultSetIndex(List aggrList, List levelList) {
        int i = 0;
        while (i < aggrList.size()) {
            CalculatedMember member = (CalculatedMember)aggrList.get(i);
            if (member.getCubeAggrDefn().getAggrLevelsInAggregationResult().equals(levelList)) {
                return member.getRsID();
            }
            ++i;
        }
        return -1;
    }

    public static ILevelDefinition[] getLevelsOnEdge(IEdgeDefinition edgeDefn) {
        if (edgeDefn == null) {
            return new ILevelDefinition[0];
        }
        ArrayList<ILevelDefinition> levelList = new ArrayList<ILevelDefinition>();
        for (IDimensionDefinition dimDefn : edgeDefn.getDimensions()) {
            for (IHierarchyDefinition hierarchyDefn : dimDefn.getHierarchy()) {
                levelList.addAll(hierarchyDefn.getLevels());
            }
        }
        ILevelDefinition[] levelDefn = new LevelDefiniton[levelList.size()];
        int i = 0;
        while (i < levelList.size()) {
            levelDefn[i] = (ILevelDefinition)levelList.get(i);
            ++i;
        }
        return levelDefn;
    }

    public static Map getRelationWithMeasure(ICubeQueryDefinition queryDefn, Map measureMapping, CubeAggrDefn[] aggrsFromCubeOperations) throws DataException {
        int i;
        ILevelDefinition[] levels;
        HashMap<Object, Relationship> measureRelationMap = new HashMap<Object, Relationship>();
        ArrayList<DimLevel> pageLevelList = new ArrayList<DimLevel>();
        ArrayList<DimLevel> rowLevelList = new ArrayList<DimLevel>();
        ArrayList<DimLevel> columnLevelList = new ArrayList<DimLevel>();
        if (queryDefn.getEdge(3) != null) {
            levels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(3));
            i = 0;
            while (i < levels.length) {
                pageLevelList.add(new DimLevel(levels[i]));
                ++i;
            }
        }
        if (queryDefn.getEdge(2) != null) {
            levels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(2));
            i = 0;
            while (i < levels.length) {
                columnLevelList.add(new DimLevel(levels[i]));
                ++i;
            }
        }
        if (queryDefn.getEdge(1) != null) {
            levels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(1));
            i = 0;
            while (i < levels.length) {
                rowLevelList.add(new DimLevel(levels[i]));
                ++i;
            }
        }
        if (queryDefn.getMeasures() != null && !queryDefn.getMeasures().isEmpty()) {
            for (MeasureDefinition measure : queryDefn.getMeasures()) {
                measureRelationMap.put(measureMapping.get(measure.getName()), new Relationship(rowLevelList, columnLevelList, pageLevelList));
            }
        }
        List orignalBindings = queryDefn.getBindings();
        CubeQueryDefinitionUtil.getNewBindingsFromCubeOperations(queryDefn);
        CubeAggrDefnOnMeasure[] cubeAggrs1 = OlapExpressionUtil.getAggrDefns(orignalBindings);
        CubeAggrDefn[] cubeAggrs = new CubeAggrDefn[cubeAggrs1.length + aggrsFromCubeOperations.length];
        System.arraycopy(cubeAggrs1, 0, cubeAggrs, 0, cubeAggrs1.length);
        System.arraycopy(aggrsFromCubeOperations, 0, cubeAggrs, cubeAggrs1.length, aggrsFromCubeOperations.length);
        if (cubeAggrs.length > 0) {
            int i2 = 0;
            while (i2 < cubeAggrs.length) {
                if (cubeAggrs[i2].getAggrName() != null) {
                    List aggrOns = cubeAggrs[i2].getAggrLevelsInAggregationResult();
                    ArrayList usedLevelOnRow = new ArrayList();
                    ArrayList usedLevelOnColumn = new ArrayList();
                    ArrayList usedLevelOnPage = new ArrayList();
                    int j = 0;
                    while (j < aggrOns.size()) {
                        if (pageLevelList.contains(aggrOns.get(j))) {
                            usedLevelOnPage.add(aggrOns.get(j));
                        }
                        if (rowLevelList.contains(aggrOns.get(j))) {
                            usedLevelOnRow.add(aggrOns.get(j));
                        } else if (columnLevelList.contains(aggrOns.get(j))) {
                            usedLevelOnColumn.add(aggrOns.get(j));
                        }
                        ++j;
                    }
                    measureRelationMap.put(cubeAggrs[i2].getName(), new Relationship(usedLevelOnRow, usedLevelOnColumn, usedLevelOnPage));
                }
                ++i2;
            }
        }
        return measureRelationMap;
    }

    public static List<IBinding> getNewBindingsFromCubeOperations(ICubeQueryDefinition cubeQueryDefn) {
        ArrayList<IBinding> list = new ArrayList<IBinding>();
        ICubeOperation[] iCubeOperationArray = cubeQueryDefn.getCubeOperations();
        int n = iCubeOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICubeOperation co = iCubeOperationArray[n2];
            IBinding[] newBindings = co.getNewBindings();
            list.addAll(Arrays.asList(newBindings));
            ++n2;
        }
        return list;
    }

    public static List<IBinding> getAllBindings(ICubeQueryDefinition cubeQueryDefn) {
        ArrayList<IBinding> result = new ArrayList<IBinding>();
        result.addAll(cubeQueryDefn.getBindings());
        result.addAll(CubeQueryDefinitionUtil.getNewBindingsFromCubeOperations(cubeQueryDefn));
        return result;
    }
}

