/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionKeyCreator;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IComparableStructure;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;

public class DimensionKey
implements IComparableStructure {
    private static IStructureCreator creator = new DimensionKeyCreator();
    private Object[] keyValues = null;
    private int dimensionPos = 0;
    private static Logger logger = Logger.getLogger(DimensionKey.class.getName());

    public DimensionKey(int keylCount) {
        logger.entering(DimensionKey.class.getName(), "DimensionKey", new Integer(keylCount));
        this.setKeyValues(new Object[keylCount]);
        logger.exiting(DimensionKey.class.getName(), "DimensionKey");
    }

    public int getKeyFieldsCount() {
        return this.getKeyValues().length;
    }

    public Object[] getFieldValues() {
        ArrayList<Object> result = new ArrayList<Object>();
        int nullIndicator = 0;
        int i = 0;
        while (i < this.getKeyValues().length) {
            if (this.getKeyValues()[i] != null) {
                nullIndicator |= 1 << i;
                result.add(this.getKeyValues()[i]);
            }
            ++i;
        }
        result.add(new Integer(this.getKeyValues().length));
        result.add(new Integer(nullIndicator));
        result.add(new Integer(this.getDimensionPos()));
        return result.toArray();
    }

    public int compareTo(Object o) {
        DimensionKey other = (DimensionKey)o;
        return CompareUtil.compare(this.getKeyValues(), other.getKeyValues());
    }

    public boolean equals(Object o) {
        DimensionKey other = (DimensionKey)o;
        int i = 0;
        while (i < this.getKeyValues().length) {
            boolean result;
            if (this.getKeyValues()[i] != null && other.getKeyValues()[i] == null || this.getKeyValues()[i] == null && other.getKeyValues()[i] != null) {
                return false;
            }
            if (this.getKeyValues()[i] != null && other.getKeyValues()[i] != null && !(result = this.getKeyValues()[i].equals(other.getKeyValues()[i]))) {
                return result;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.getKeyValues().length) {
            buffer.append(this.getKeyValues()[i]);
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public static IStructureCreator getCreator() {
        return creator;
    }

    public void setKeyValues(Object[] keyValues) {
        this.keyValues = keyValues;
    }

    public Object[] getKeyValues() {
        return this.keyValues;
    }

    public void setDimensionPos(int dimensionPos) {
        this.dimensionPos = dimensionPos;
    }

    public int getDimensionPos() {
        return this.dimensionPos;
    }
}

