/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import org.eclipse.birt.data.engine.cache.Constants;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRowComparator;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class SortedAggregationRowArray {
    IAggregationResultSet aggregationResultSet;
    private IDiskArray sortedRows = null;

    public SortedAggregationRowArray(IAggregationResultSet aggregationResultSet, DimLevel[] keyLevels) throws IOException {
        this.aggregationResultSet = aggregationResultSet;
        if (keyLevels != null && this.needReSort(keyLevels)) {
            this.sort(keyLevels);
        }
    }

    public SortedAggregationRowArray(IAggregationResultSet aggregationResultSet) throws IOException {
        this.aggregationResultSet = aggregationResultSet;
        this.sort(aggregationResultSet.getAllLevels());
    }

    private void sort(DimLevel[] keyLevels) throws IOException {
        int[] keyLevelIndexes = this.getKeyLevelIndexs(keyLevels);
        AggregationResultRowComparator comparator = new AggregationResultRowComparator(keyLevelIndexes);
        DiskSortedStack diskSortedStack = new DiskSortedStack(Constants.FACT_TABLE_BUFFER_SIZE, false, comparator, AggregationResultRow.getCreator());
        int i = 0;
        while (i < this.aggregationResultSet.length()) {
            this.aggregationResultSet.seek(i);
            IAggregationResultRow row = this.aggregationResultSet.getCurrentRow();
            AggregationResultRow newRow = new AggregationResultRow();
            newRow.setLevelMembers(row.getLevelMembers());
            newRow.setAggregationValues(row.getAggregationValues());
            diskSortedStack.push(newRow);
            ++i;
        }
        this.sortedRows = new BufferedStructureArray(AggregationResultRow.getCreator(), Constants.LIST_BUFFER_SIZE);
        AggregationResultRow row = (AggregationResultRow)diskSortedStack.pop();
        while (row != null) {
            this.sortedRows.add(row);
            row = (AggregationResultRow)diskSortedStack.pop();
        }
    }

    private int[] getKeyLevelIndexs(DimLevel[] keyLevels) {
        int[] keyLevelIndexes = new int[keyLevels.length];
        DimLevel[] allLevels = this.aggregationResultSet.getAllLevels();
        int i = 0;
        while (i < keyLevels.length) {
            int j = 0;
            while (j < allLevels.length) {
                if (keyLevels[i].equals(allLevels[j])) {
                    keyLevelIndexes[i] = j;
                }
                ++j;
            }
            ++i;
        }
        return keyLevelIndexes;
    }

    private boolean needReSort(DimLevel[] keyLevels) {
        DimLevel[] allLevels = this.aggregationResultSet.getAllLevels();
        int i = 0;
        while (i < keyLevels.length) {
            if (!keyLevels[i].equals(allLevels[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IAggregationResultRow get(int index) throws IOException {
        if (this.sortedRows != null) {
            return (IAggregationResultRow)this.sortedRows.get(index);
        }
        this.aggregationResultSet.seek(index);
        return this.aggregationResultSet.getCurrentRow();
    }

    public int size() {
        if (this.sortedRows != null) {
            return this.sortedRows.size();
        }
        return this.aggregationResultSet.length();
    }

    public IDiskArray getSortedRows() {
        return this.sortedRows;
    }
}

