/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.instance;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.script.IRowData;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.instance.IReportElementInstance;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ElementUtil;
import org.eclipse.birt.report.engine.script.internal.RowData;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.engine.script.internal.instance.StyleInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class ReportElementInstance
implements IReportElementInstance {
    protected IContent content;
    private ExecutionContext context;
    private RowData rowData;
    protected RunningState runningState;

    public ReportElementInstance(IContent content, ExecutionContext context, RunningState runningState) {
        this.content = content;
        this.context = context;
        this.runningState = runningState;
    }

    protected ReportElementInstance(ExecutionContext context, RunningState runningState) {
        this.context = context;
        this.runningState = runningState;
    }

    public IScriptStyle getStyle() {
        return new StyleInstance(this.content.getStyle(), this.runningState);
    }

    public Object getNamedExpressionValue(String name) {
        return this.getUserPropertyValue(name);
    }

    public Object getUserPropertyValue(String name) {
        Expression expr;
        Map<String, Object> values = this.content.getUserProperties();
        if (values != null && values.containsKey(name)) {
            return values.get(name);
        }
        ReportElementDesign design = (ReportElementDesign)this.content.getGenerateBy();
        Map<String, Expression> props = design.getUserProperties();
        if (props != null && (expr = props.get(name)) != null && expr.getType() == 0) {
            Expression.Constant cs = (Expression.Constant)expr;
            return cs.getValue();
        }
        return null;
    }

    public void setUserPropertyValue(String name, Object value) throws ScriptException {
        Map<String, Object> values = this.content.getUserProperties();
        if (values == null) {
            values = new HashMap<String, Object>();
            this.content.setUserProperties(values);
        }
        values.put(name, value);
    }

    public IReportElementInstance getParent() throws ScriptException {
        try {
            return ElementUtil.getInstance(this.content.getParent(), this.context, this.runningState);
        }
        catch (BirtException e) {
            ScriptException scriptException = new ScriptException(e.getLocalizedMessage());
            scriptException.initCause(e);
            throw scriptException;
        }
    }

    public String getHorizontalPosition() {
        DimensionType x = this.content.getX();
        if (x != null) {
            return x.toString();
        }
        return null;
    }

    public void setHorizontalPosition(String position) {
        this.content.setX(DimensionType.parserUnit(position));
    }

    public String getVerticalPosition() {
        DimensionType y = this.content.getY();
        if (y != null) {
            return y.toString();
        }
        return null;
    }

    public void setVerticalPosition(String position) {
        this.content.setY(DimensionType.parserUnit(position));
    }

    public String getWidth() {
        DimensionType width = this.content.getWidth();
        if (width != null) {
            return width.toString();
        }
        return null;
    }

    public void setWidth(String width) {
        this.content.setWidth(DimensionType.parserUnit(width));
    }

    public String getHeight() {
        DimensionType height = this.content.getHeight();
        if (height != null) {
            return height.toString();
        }
        return null;
    }

    public void setHeight(String height) {
        this.content.setHeight(DimensionType.parserUnit(height));
    }

    public IRowData getRowData() throws ScriptException {
        DesignElementHandle handle;
        ReportItemDesign design;
        if (this.rowData != null) {
            return this.rowData;
        }
        Object objGen = this.content.getGenerateBy();
        if (objGen instanceof ReportItemDesign && (design = (ReportItemDesign)objGen).getQuery() != null && (handle = design.getHandle()) instanceof ReportItemHandle) {
            IBaseResultSet rset = this.context.getResultSet();
            this.rowData = new RowData(rset, (ReportItemHandle)handle);
            return this.rowData;
        }
        IReportElementInstance parent = this.getParent();
        if (parent != null) {
            return parent.getRowData();
        }
        return null;
    }
}

