/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.extension.internal;

import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IQueryContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.ReportElementHandle;

public class QueryContext
implements IQueryContext {
    Report report;
    ExecutionContext context;
    ReportQueryBuilder builder;
    ReportItemDesign design;

    public QueryContext(ExecutionContext context, ReportQueryBuilder builder) {
        this.report = context.getReport();
        this.context = context;
        this.builder = builder;
    }

    public IDataQueryDefinition[] createQuery(IDataQueryDefinition parent, ReportElementHandle handle) {
        this.design = this.report.findDesign(handle);
        return this.builder.build(parent, this.design);
    }

    public DataRequestSession getDataRequestSession() {
        if (this.context != null) {
            try {
                IDataEngine dataEngine = this.context.getDataEngine();
                return dataEngine.getDTESession();
            }
            catch (EngineException e) {
                this.context.addException(e);
            }
        }
        return null;
    }
}

