/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service.xml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.epp.internal.mpc.core.service.xml.CategoriesContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.CategoryContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.DefaultContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.FavoritesContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.FeaturedContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.IusContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.MarketContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.MarketplaceContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.NodeContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.PlatformsContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.PopularContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.RecentContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.SearchContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.UnmarshalContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Unmarshaller
extends DefaultHandler {
    private Map<String, UnmarshalContentHandler> elementNameToUnmarshalContentHandler = new HashMap<String, UnmarshalContentHandler>();
    private UnmarshalContentHandler currentHandler;
    private Object model;

    public Unmarshaller() {
        this.elementNameToUnmarshalContentHandler.put("marketplace", new MarketplaceContentHandler());
        this.elementNameToUnmarshalContentHandler.put("market", new MarketContentHandler());
        this.elementNameToUnmarshalContentHandler.put("category", new CategoryContentHandler());
        this.elementNameToUnmarshalContentHandler.put("node", new NodeContentHandler());
        this.elementNameToUnmarshalContentHandler.put("categories", new CategoriesContentHandler());
        this.elementNameToUnmarshalContentHandler.put("ius", new IusContentHandler());
        this.elementNameToUnmarshalContentHandler.put("platforms", new PlatformsContentHandler());
        this.elementNameToUnmarshalContentHandler.put("search", new SearchContentHandler());
        this.elementNameToUnmarshalContentHandler.put("recent", new RecentContentHandler());
        this.elementNameToUnmarshalContentHandler.put("featured", new FeaturedContentHandler());
        this.elementNameToUnmarshalContentHandler.put("popular", new PopularContentHandler());
        this.elementNameToUnmarshalContentHandler.put("favorites", new FavoritesContentHandler());
    }

    public static Object parse(InputSource input) throws IOException, SAXException {
        XMLReader xmlReader;
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        try {
            xmlReader = parserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        Unmarshaller unmarshaller = new Unmarshaller();
        xmlReader.setContentHandler(unmarshaller);
        xmlReader.parse(input);
        return unmarshaller.getModel();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.computeHandler(localName);
        this.currentHandler.startElement(uri, localName, attributes);
    }

    private void computeHandler(String localName) {
        if (this.currentHandler == null) {
            this.currentHandler = this.elementNameToUnmarshalContentHandler.get(localName);
            if (this.currentHandler == null) {
                this.currentHandler = new DefaultContentHandler();
            }
            this.currentHandler.setUnmarshaller(this);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentHandler.endElement(uri, localName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentHandler != null) {
            this.currentHandler.characters(ch, start, length);
        }
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    protected UnmarshalContentHandler getCurrentHandler() {
        return this.currentHandler;
    }

    protected void setCurrentHandler(UnmarshalContentHandler currentHandler) {
        this.currentHandler = currentHandler;
    }
}

