/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant;

import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.ConstantExpressionWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class StringConstantBuilderPage
extends WizardPage
implements SelectionListener,
KeyListener {
    protected SQLQueryObject sqlStatement;
    protected QueryValueExpression inputSQLExpression;
    protected QueryValueExpression updatedSQLExpression;
    private Text constantText;
    private Text startLabel;
    private Text endLabel;
    private Text previewExpressionText;
    private Button charStringButton;
    private Button hexButton;
    private Button hostVariableButton;
    private Button graphicStringButton;
    private Button clearButton;
    private boolean isSingleQuotedString = true;
    private boolean isDoubleQuotedString = false;
    private boolean isOtherString = false;
    private SQLDomainModel domainModel;
    private String userText = "";
    boolean isXMLFunction = false;

    public StringConstantBuilderPage(SQLQueryObject sqlStatementArg, QueryValueExpression sqlExpr, SQLDomainModel dModel) {
        super(Messages._UI_WIZARD_STRING_CONSTANT_TITLE);
        this.setTitle(Messages._UI_WIZARD_STRING_CONSTANT_HEADING);
        this.setDescription(Messages._UI_WIZARD_STRING_CONSTANT_EXPL);
        this.setPageComplete(true);
        this.sqlStatement = sqlStatementArg;
        this.inputSQLExpression = sqlExpr;
        this.domainModel = dModel;
    }

    public StringConstantBuilderPage(QueryStatement sqlStatementArg, QueryValueExpression sqlExpr) {
        super(Messages._UI_WIZARD_STRING_CONSTANT_TITLE);
        this.setTitle(Messages._UI_WIZARD_STRING_CONSTANT_HEADING);
        this.setDescription(Messages._UI_WIZARD_STRING_CONSTANT_EXPL);
        this.setPageComplete(true);
        this.sqlStatement = sqlStatementArg;
        this.inputSQLExpression = sqlExpr;
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)mainPanel, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqle0800");
        GridLayout mainPanelLayout = new GridLayout();
        mainPanel.setLayout((Layout)mainPanelLayout);
        mainPanel.setLayoutData((Object)ViewUtility.createFill());
        Composite topPanel = new Composite(mainPanel, 0);
        GridLayout topPanelLayout = new GridLayout();
        topPanelLayout.numColumns = 3;
        topPanelLayout.marginWidth = 0;
        topPanelLayout.marginHeight = 0;
        topPanelLayout.horizontalSpacing = 0;
        topPanelLayout.makeColumnsEqualWidth = false;
        topPanel.setLayout((Layout)topPanelLayout);
        topPanel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.startLabel = new Text(topPanel, 2060);
        this.startLabel.setText("     ' ");
        this.constantText = new Text(topPanel, 2308);
        this.constantText.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.constantText.addKeyListener((KeyListener)this);
        this.endLabel = new Text(topPanel, 2060);
        this.endLabel.setText(" ' ");
        this.clearButton = new Button(mainPanel, 8);
        this.clearButton.setText(Messages._UI_BUTTON_CLEAR);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.clearButton.setLayoutData((Object)data);
        this.clearButton.addSelectionListener((SelectionListener)this);
        Group constantTypeGroup = ViewUtility.createGroup(mainPanel, 1, Messages._UI_GROUP_STRING_TYPE, false);
        this.charStringButton = new Button((Composite)constantTypeGroup, 16);
        this.charStringButton.setText(Messages._UI_RADIO_CHARACTER);
        this.charStringButton.addSelectionListener((SelectionListener)this);
        this.hexButton = new Button((Composite)constantTypeGroup, 16);
        this.hexButton.setText(Messages._UI_RADIO_HEX);
        this.hexButton.addSelectionListener((SelectionListener)this);
        this.graphicStringButton = new Button((Composite)constantTypeGroup, 16);
        this.graphicStringButton.setText(Messages._UI_RADIO_GRAPHIC);
        this.graphicStringButton.addSelectionListener((SelectionListener)this);
        if (this.inputSQLExpression == null) {
            this.charStringButton.setSelection(true);
        }
        this.hostVariableButton = new Button((Composite)constantTypeGroup, 16);
        this.hostVariableButton.setText(Messages._UI_RADIO_HOST_VARIABLE_NAME);
        this.hostVariableButton.addSelectionListener((SelectionListener)this);
        ViewUtility.createVerticalFiller(mainPanel, 1);
        Label previewLabel = new Label(mainPanel, 256);
        previewLabel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        previewLabel.setText(Messages._UI_LABEL_PREVIEW_CONSTANT_EXPRESSION);
        this.previewExpressionText = new Text(mainPanel, 2060);
        this.previewExpressionText.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.updatePreview();
        this.setControl((Control)mainPanel);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.widget == this.hexButton) {
            this.enableConstantText();
            this.startLabel.setText("   X'  ");
            this.endLabel.setText(" ' ");
            this.updatePreview();
        } else if (se.widget == this.graphicStringButton) {
            this.enableConstantText();
            this.startLabel.setText("   N'  ");
            this.endLabel.setText(" ' ");
            this.updatePreview();
        } else if (se.widget == this.charStringButton) {
            this.enableConstantText();
            if (this.isSingleQuotedString) {
                this.startLabel.setText("     '");
                this.endLabel.setText(" ' ");
            } else if (this.isDoubleQuotedString) {
                this.startLabel.setText("     \"");
                this.endLabel.setText(" \" ");
            } else if (this.isOtherString) {
                this.startLabel.setText("      ");
                this.endLabel.setText("   ");
            }
            this.updatePreview();
        } else if (se.widget == this.hostVariableButton) {
            this.startLabel.setText("   " + this.getProperHostDelimiter());
            if (this.getProperHostDelimiter().equals("?") && this.constantText.isEnabled()) {
                this.userText = this.constantText.getText();
                this.constantText.setText("");
                this.constantText.setEnabled(false);
            }
            this.endLabel.setText("");
            this.updatePreview();
        } else if (se.widget == this.clearButton) {
            this.constantText.setText("");
            this.updatePreview();
        }
    }

    private void enableConstantText() {
        if (!this.constantText.getEnabled()) {
            this.constantText.setEnabled(true);
            this.constantText.setText(this.userText);
        }
    }

    public void keyPressed(KeyEvent ke) {
        this.updatePreview();
    }

    public void keyReleased(KeyEvent ke) {
        this.updatePreview();
    }

    public void setIsXMLFunction(boolean isXMLFunction) {
        this.isXMLFunction = isXMLFunction;
    }

    private void updatePreview() {
        if (this.hexButton.getSelection()) {
            this.previewExpressionText.setText("X'" + this.constantText.getText() + "'");
        } else if (this.graphicStringButton.getSelection()) {
            this.previewExpressionText.setText("N'" + this.constantText.getText() + "'");
        } else if (this.charStringButton.getSelection()) {
            if (this.isSingleQuotedString) {
                this.previewExpressionText.setText("'" + this.constantText.getText() + "'");
            } else if (this.isDoubleQuotedString) {
                this.previewExpressionText.setText("\"" + this.constantText.getText() + "\"");
            } else if (this.isOtherString) {
                this.previewExpressionText.setText(this.constantText.getText());
            }
        } else if (this.hostVariableButton.getSelection()) {
            this.previewExpressionText.setText(String.valueOf(this.getProperHostDelimiter()) + this.constantText.getText());
        }
    }

    public void setInputExpression(QueryValueExpression in) {
        this.inputSQLExpression = in;
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateFinishButton();
            if (this.inputSQLExpression != null) {
                String input = this.inputSQLExpression.getSQL();
                if (input.startsWith("X'")) {
                    this.startLabel.setText("   X'  ");
                    this.constantText.setText(input.substring(2, input.length() - 1));
                    this.endLabel.setText(" ' ");
                    this.hexButton.setSelection(true);
                } else if (input.startsWith("N'")) {
                    this.startLabel.setText("   N'  ");
                    this.constantText.setText(input.substring(2, input.length() - 1));
                    this.endLabel.setText(" ' ");
                    this.graphicStringButton.setSelection(true);
                } else if (input.startsWith(this.getProperHostDelimiter())) {
                    this.startLabel.setText("   " + this.getProperHostDelimiter());
                    if (this.getProperHostDelimiter().equals("?")) {
                        this.constantText.setEnabled(false);
                    }
                    this.constantText.setText(input.substring(1, input.length()));
                    this.endLabel.setText("   ");
                    this.hostVariableButton.setSelection(true);
                } else if (input.startsWith("'")) {
                    this.isSingleQuotedString = true;
                    this.isDoubleQuotedString = false;
                    this.isOtherString = false;
                    this.startLabel.setText("     '");
                    this.constantText.setText(input.substring(1, input.length() - 1));
                    this.endLabel.setText(" ' ");
                    this.charStringButton.setSelection(true);
                } else if (input.startsWith("\"")) {
                    this.isSingleQuotedString = false;
                    this.isDoubleQuotedString = true;
                    this.isOtherString = false;
                    this.startLabel.setText("     \"");
                    this.constantText.setText(input.substring(1, input.length() - 1));
                    this.endLabel.setText(" \" ");
                    this.charStringButton.setSelection(true);
                } else if (!this.isXMLFunction) {
                    this.isSingleQuotedString = true;
                    this.isDoubleQuotedString = false;
                    this.isOtherString = false;
                    this.startLabel.setText("     '");
                    this.constantText.setText(input);
                    this.endLabel.setText(" ' ");
                    this.charStringButton.setSelection(true);
                } else {
                    this.isSingleQuotedString = false;
                    this.isDoubleQuotedString = false;
                    this.isOtherString = true;
                    this.startLabel.setText("      ");
                    this.endLabel.setText("   ");
                    this.constantText.setText(input);
                    this.charStringButton.setSelection(true);
                }
                this.constantText.append("");
                this.updatePreview();
            }
            this.constantText.setFocus();
        }
    }

    private void updateFinishButton() {
        boolean isComplete = true;
        this.setPageComplete(isComplete);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setAllPagesComplete(true);
        } else if (this.getWizard() instanceof ConstantExpressionWizard) {
            ConstantExpressionWizard wiz = (ConstantExpressionWizard)this.getWizard();
            wiz.setConstantOptionsPageComplete(true);
        }
    }

    public boolean performOk() {
        QueryValueExpression sqlConstantExpr;
        String finalConstant = "";
        if (this.charStringButton.getSelection()) {
            if (this.isSingleQuotedString) {
                finalConstant = "'" + this.constantText.getText() + "'";
            } else if (this.isDoubleQuotedString) {
                finalConstant = "\"" + this.constantText.getText() + "\"";
            } else if (this.isOtherString) {
                finalConstant = this.constantText.getText();
            }
        } else {
            finalConstant = this.hostVariableButton.getSelection() ? String.valueOf(this.getProperHostDelimiter()) + this.constantText.getText() : (this.hexButton.getSelection() ? "X'" + this.constantText.getText() + "'" : (this.graphicStringButton.getSelection() ? "N'" + this.constantText.getText() + "'" : "'" + this.constantText.getText() + "'"));
        }
        this.updatedSQLExpression = sqlConstantExpr = ExpressionHelper.createExpression(finalConstant);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        } else if (this.getWizard() instanceof ConstantExpressionWizard) {
            ConstantExpressionWizard wiz = (ConstantExpressionWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        }
        return true;
    }

    public boolean currentPage() {
        return this.isCurrentPage();
    }

    private String getProperHostDelimiter() {
        String delimiter = "";
        if (this.domainModel != null) {
            delimiter = this.domainModel.getDatabaseDefinition().getHostVariableMarker();
        }
        return delimiter;
    }
}

