/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api;

import java.util.Map;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.script.DataAdapterTopLevelScope;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class DataSessionContext {
    public static final int MODE_GENERATION = 1;
    public static final int MODE_PRESENTATION = 2;
    public static final int MODE_DIRECT_PRESENTATION = 3;
    public static final int MODE_UPDATE = 4;
    public static final int CACHE_USE_DEFAULT = 1;
    public static final int CACHE_USE_DISABLE = 2;
    public static final int CACHE_USE_ALWAYS = 3;
    private DataEngineContext context = null;
    private boolean hasExternalScope = false;
    private int mode = 3;
    private Scriptable topScope;
    private IDocArchiveReader docReader;
    private IDocArchiveWriter docWriter;
    private boolean cacheSet = false;
    private int cacheOption = 1;
    private int cacheCount = 0;
    private ModuleHandle moduleHandle;
    private Map appContext;
    private ScriptContext sContext;
    private ClassLoader appClassLoader;

    public DataSessionContext(int mode) throws BirtException {
        this(mode, null, null);
    }

    public DataSessionContext(int mode, ModuleHandle moduleHandle) throws BirtException {
        this(mode, moduleHandle, null, null);
    }

    public DataSessionContext(int mode, ModuleHandle moduleHandle, Scriptable topScope) throws BirtException {
        this(mode, moduleHandle, DataSessionContext.prepareScriptContext(topScope), null);
    }

    private static ScriptContext prepareScriptContext(Scriptable topScope) {
        ScriptContext cx = new ScriptContext();
        cx.newContext((Object)topScope);
        return cx;
    }

    public DataSessionContext(int mode, ModuleHandle moduleHandle, ScriptContext scriptContext, ClassLoader classLoader) throws AdapterException {
        try {
            if (mode != 1 && mode != 2 && mode != 3 && mode != 4) {
                throw new AdapterException("adaptor.invalid.mode", new Integer(mode));
            }
            this.mode = mode;
            this.moduleHandle = moduleHandle;
            this.appClassLoader = classLoader;
            if (scriptContext == null) {
                scriptContext = new ScriptContext().newContext((Object)this.getTopScope());
            }
            this.sContext = scriptContext;
            this.topScope = ((IDataScriptEngine)scriptContext.getScriptEngine("javascript")).getJSScope(scriptContext);
            this.hasExternalScope = this.topScope != null;
        }
        catch (BirtException e) {
            throw new AdapterException(e.getErrorCode(), e);
        }
    }

    public void setDocumentReader(IDocArchiveReader reader) {
        this.docReader = reader;
    }

    public void setDocumentWriter(IDocArchiveWriter writer) {
        this.docWriter = writer;
    }

    public IDocArchiveWriter getDocumentWriter() {
        return this.docWriter;
    }

    public void setCacheOption(int option, int cacheCount) throws BirtException {
        if (option != 1 && option != 2 && option != 3) {
            throw new AdapterException("invalid.cache.option", new Integer(option));
        }
        this.cacheSet = true;
        this.cacheOption = option;
        this.cacheCount = cacheCount;
    }

    public DataEngineContext getDataEngineContext() throws BirtException {
        if (this.context != null) {
            return this.context;
        }
        this.context = DataEngineContext.newInstance((int)this.mode, (ScriptContext)this.sContext, (IDocArchiveReader)this.docReader, (IDocArchiveWriter)this.docWriter, (ClassLoader)this.appClassLoader);
        if (this.cacheSet) {
            this.context.setCacheOption(this.cacheOption, this.cacheCount);
        }
        return this.context;
    }

    public void setDataEngineContext(DataEngineContext context) {
        if (context != null) {
            this.context = context;
        }
    }

    public boolean hasExternalScope() {
        return this.hasExternalScope;
    }

    public Scriptable getTopScope() {
        if (this.topScope == null) {
            Context cx = Context.enter();
            this.topScope = new DataAdapterTopLevelScope(cx, this.moduleHandle);
            Context.exit();
        }
        return this.topScope;
    }

    public ModuleHandle getModuleHandle() {
        return this.moduleHandle;
    }

    public void setAppContext(Map context) {
        this.appContext = context;
    }

    public Map getAppContext() {
        return this.appContext;
    }
}

