/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.notifications;

import java.util.Collections;
import java.util.Date;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.GradientCanvas;
import org.eclipse.mylyn.internal.tasks.core.notifications.IServiceMessageListener;
import org.eclipse.mylyn.internal.tasks.core.notifications.ServiceMessage;
import org.eclipse.mylyn.internal.tasks.core.notifications.ServiceMessageEvent;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.framework.Version;

public class TaskListServiceMessageControl
implements IServiceMessageListener {
    private Label imageLabel;
    private Label titleLabel;
    private Link descriptionLabel;
    private GridData headData;
    private final Composite parent;
    private GradientCanvas head;
    private ImageHyperlink closeLink;
    private ImageHyperlink settingsLink;
    private ServiceMessage currentMessage;

    public TaskListServiceMessageControl(Composite parent) {
        this.parent = parent;
    }

    private void setTitleImage(Image image) {
        this.imageLabel.setImage(image);
    }

    private void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    private void setDescription(String description) {
        this.descriptionLabel.setText(description);
    }

    public Control createControl(Composite parent) {
        FormColors colors = TasksUiPlugin.getDefault().getFormColors(parent.getDisplay());
        this.head = new GradientCanvas(parent, 0);
        GridLayout headLayout = new GridLayout();
        headLayout.marginHeight = 0;
        headLayout.marginWidth = 0;
        headLayout.horizontalSpacing = 0;
        headLayout.verticalSpacing = 0;
        headLayout.numColumns = 1;
        this.head.setLayout((Layout)headLayout);
        this.headData = new GridData(4, 128, true, false);
        this.head.setLayoutData((Object)this.headData);
        Color top = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color bot = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        this.head.setBackgroundGradient(new Color[]{bot, top}, new int[]{100}, true);
        this.head.setSeparatorVisible(true);
        this.head.setSeparatorAlignment(128);
        this.head.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", colors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        this.head.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", colors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
        this.head.putColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT", colors.getColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT"));
        this.head.putColor("org.eclipse.ui.forms.H_H_HOVER_FULL", colors.getColor("org.eclipse.ui.forms.H_H_HOVER_FULL"));
        this.head.putColor("org.eclipse.ui.forms.TB_TOGGLE", colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.head.putColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER", colors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        this.head.setLayout((Layout)layout);
        this.imageLabel = new Label((Composite)this.head, 0);
        this.titleLabel = new Label((Composite)this.head, 0);
        TaskListServiceMessageControl.setHeaderFontSizeAndStyle((Control)this.titleLabel);
        Composite buttonsComp = new Composite((Composite)this.head, 0);
        TableWrapData data = new TableWrapData();
        data.align = 8;
        buttonsComp.setLayoutData((Object)data);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.horizontalSpacing = 0;
        gLayout.verticalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.verticalSpacing = 0;
        buttonsComp.setLayout((Layout)gLayout);
        this.closeLink = new ImageHyperlink(buttonsComp, 0);
        this.closeLink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.NOTIFICATION_CLOSE));
        this.closeLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskListServiceMessageControl.this.closeMessage();
            }

            public void linkEntered(HyperlinkEvent e) {
                TaskListServiceMessageControl.this.closeLink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.NOTIFICATION_CLOSE_HOVER));
            }

            public void linkExited(HyperlinkEvent e) {
                TaskListServiceMessageControl.this.closeLink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.NOTIFICATION_CLOSE));
            }
        });
        new Label((Composite)this.head, 0).setText(" ");
        this.descriptionLabel = new Link((Composite)this.head, 64);
        this.descriptionLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.text != null) {
                    if (e.text.toLowerCase().equals("connect")) {
                        TaskListServiceMessageControl.this.closeMessage();
                        new AddRepositoryAction().run();
                    } else if (e.text.toLowerCase().equals("discovery")) {
                        TaskListServiceMessageControl.this.closeMessage();
                        Command discoveryWizardCommand = TasksUiInternal.getConfiguredDiscoveryWizardCommand();
                        if (discoveryWizardCommand != null && discoveryWizardCommand.isEnabled()) {
                            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                            try {
                                discoveryWizardCommand.executeWithChecks(TaskListServiceMessageControl.createExecutionEvent(discoveryWizardCommand, handlerService));
                            }
                            catch (Exception e1) {
                                Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)Messages.SelectRepositoryConnectorPage_discoveryProblemMessage, (Object[])new Object[]{e1.getMessage()}), (Throwable)e1);
                                TasksUiInternal.logAndDisplayStatus(Messages.SelectRepositoryConnectorPage_discoveryProblemTitle, (IStatus)status);
                            }
                        }
                    }
                }
            }
        });
        data = new TableWrapData();
        data.colspan = 2;
        data.grabHorizontal = true;
        this.descriptionLabel.setLayoutData((Object)data);
        return this.head;
    }

    static ExecutionEvent createExecutionEvent(Command command, IHandlerService handlerService) {
        return new ExecutionEvent(command, Collections.emptyMap(), null, (Object)TasksUiInternal.createDiscoveryWizardEvaluationContext(handlerService));
    }

    private void closeMessage() {
        if (this.currentMessage != null) {
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.servicemessage.id", this.currentMessage.getId());
        }
        if (this.head != null && !this.head.isDisposed()) {
            this.head.dispose();
        }
        if (!this.parent.isDisposed()) {
            this.parent.layout(true);
        }
    }

    private static Font setHeaderFontSizeAndStyle(Control text) {
        FontData[] fontData;
        float sizeFactor = 1.2f;
        Font initialFont = text.getFont();
        FontData[] fontDataArray = fontData = initialFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setHeight((int)((float)element.getHeight() * sizeFactor));
            element.setStyle(element.getStyle() | 1);
            ++n2;
        }
        final Font textFont = new Font((Device)text.getDisplay(), fontData);
        text.setFont(textFont);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                textFont.dispose();
            }
        });
        Color color = TasksUiPlugin.getDefault().getFormColors(text.getDisplay()).getColor("org.eclipse.ui.forms.TITLE");
        text.setForeground(color);
        return textFont;
    }

    public void handleEvent(ServiceMessageEvent event) {
        switch (event.getEventKind()) {
            case MESSAGE_UPDATE: {
                IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.checktime", new Date().getTime());
                String lastMessageId = preferenceStore.getString("org.eclipse.mylyn.tasks.ui.servicemessage.id");
                for (final ServiceMessage message : event.getMessages()) {
                    if (!message.isValid() || message.getId().equals("-1") || lastMessageId.equals(message.getId()) || !this.isForCurrentVersion(message)) continue;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            TaskListServiceMessageControl.this.setMessage(message);
                        }
                    });
                }
                break;
            }
            case STOP: {
                if (this.head != null && !this.head.isDisposed()) {
                    this.head.dispose();
                }
                if (this.parent == null || this.parent.isDisposed()) break;
                this.parent.layout(true);
            }
        }
    }

    private boolean isForCurrentVersion(ServiceMessage message) {
        if (message.getVersion() == null) {
            return true;
        }
        try {
            VersionRange version = new VersionRange(message.getVersion());
            String versionString = (String)TasksUiPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
            return version.isIncluded(new Version(versionString));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void setMessage(ServiceMessage message) {
        if (!this.parent.isDisposed() && message != null && (this.head == null || this.head.isDisposed())) {
            this.createControl(this.parent);
            if (message.getETag() != null && message.getLastModified() != null) {
                IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.etag", message.getETag());
                preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.lastmodified", message.getLastModified());
            }
            this.currentMessage = message;
            this.setTitle(message.getTitle());
            this.setDescription(message.getDescription());
            this.setTitleImage(Dialog.getImage((String)message.getImage()));
            this.parent.layout(true);
        }
    }
}

