/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.oda;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.oda.OdaAggregationHelper;
import org.eclipse.birt.report.model.api.oda.interfaces.IAggregationDefn;
import org.eclipse.birt.report.model.api.oda.interfaces.IBirtAggregationConstants;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class AggregationDefn
implements IAggregationDefn {
    protected static final int UNDEFINED = -1;
    protected String birtAggregationId = null;
    protected String birtAggregationDisplayName = null;
    protected int minInputVar = -1;
    protected int maxInputVar = -1;
    protected boolean supportsUnboundedMaxInputVar = false;
    protected boolean canIgnoreDuplicateValues = false;
    protected boolean canIgnoreNullValues = false;
    private static Logger logger = Logger.getLogger(AggregationDefn.class.getName());

    AggregationDefn() {
    }

    public AggregationDefn(String birtAggregationId) throws IllegalArgumentException {
        this.birtAggregationId = birtAggregationId;
        if (!OdaAggregationHelper.birtPredefinedAggregationConstants.contains(birtAggregationId)) {
            throw new IllegalArgumentException("The Birt filter expression Id" + birtAggregationId + " is not valid.");
        }
        this.initBirtAggregation(birtAggregationId.toLowerCase().hashCode(), birtAggregationId);
    }

    public boolean canIgnoreDuplicateValues() {
        return false;
    }

    public boolean canIgnoreNullValues() {
        return false;
    }

    public String getBirtAggregationDisplayName() {
        return this.birtAggregationDisplayName;
    }

    public String getBirtAggregationId() {
        return this.birtAggregationId;
    }

    public Integer getMaxInputVariables() {
        if (this.maxInputVar == -1) {
            return null;
        }
        return this.maxInputVar;
    }

    public Integer getMinInputVariables() {
        if (this.minInputVar == -1) {
            return null;
        }
        return this.minInputVar;
    }

    public String getODAAggregationDisplayName() {
        return null;
    }

    public String getODAAggregationId() {
        return null;
    }

    public String getProviderExtensionId() {
        return null;
    }

    public boolean supportsUnboundedMaxInputVariables() {
        return false;
    }

    protected void initBirtAggregation(int aggregationId, String id) {
        if (IBirtAggregationConstants.AGGREGATION_FUNCTION_AVERAGE == aggregationId) {
            this.birtAggregationId = "average";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_COUNT == aggregationId) {
            this.birtAggregationId = "count";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_COUNTDISTINCT == aggregationId) {
            this.birtAggregationId = "count-distinct";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_FIRST == aggregationId) {
            this.birtAggregationId = "count-distinct";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_IRR == aggregationId) {
            this.birtAggregationId = "irr";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_IS_BOTTOM_N == aggregationId) {
            this.birtAggregationId = "is-bottom-n";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_IS_BOTTOM_N_PERCENT == aggregationId) {
            this.birtAggregationId = "is-bottom-n-percent";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_IS_TOP_N == aggregationId) {
            this.birtAggregationId = "is-top-n";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_IS_TOP_N_PERCENT == aggregationId) {
            this.birtAggregationId = "is-top-n-percent";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_LAST == aggregationId) {
            this.birtAggregationId = "last";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_MAX == aggregationId) {
            this.birtAggregationId = "max";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_MEDIAN == aggregationId) {
            this.birtAggregationId = "median";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_MIN == aggregationId) {
            this.birtAggregationId = "min";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_MIRR == aggregationId) {
            this.birtAggregationId = "mirr";
            this.minInputVar = 3;
            this.maxInputVar = 3;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_MODE == aggregationId) {
            this.birtAggregationId = "mode";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_MOVINGAVE == aggregationId) {
            this.birtAggregationId = "moving-ave";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_NPV == aggregationId) {
            this.birtAggregationId = "npv";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_PERCENT_RANK == aggregationId) {
            this.birtAggregationId = "percent-rank";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_PERCENT_SUM == aggregationId) {
            this.birtAggregationId = "percent-sum";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_PERCENTILE == aggregationId) {
            this.birtAggregationId = "percentile";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_RANK == aggregationId) {
            this.birtAggregationId = "rank";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_RUNNINGCOUNT == aggregationId) {
            this.birtAggregationId = "running-count";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_RUNNINGNPV == aggregationId) {
            this.birtAggregationId = "running-npv";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_RUNNINGSUM == aggregationId) {
            this.birtAggregationId = "running-sum";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_STDDEV == aggregationId) {
            this.birtAggregationId = "stddev";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_SUM == aggregationId) {
            this.birtAggregationId = "sum";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_TOP_QUARTILE == aggregationId) {
            this.birtAggregationId = "quartile";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_VARIANCE == aggregationId) {
            this.birtAggregationId = "variance";
            this.minInputVar = 1;
            this.maxInputVar = 1;
        } else if (IBirtAggregationConstants.AGGREGATION_FUNCTION_WEIGHTEDAVG == aggregationId) {
            this.birtAggregationId = "weighted-avg";
            this.minInputVar = 2;
            this.maxInputVar = 2;
        } else {
            logger.log(Level.SEVERE, "The Birt filter expression Id: " + id + " is not valid.");
        }
        if (this.birtAggregationId != null) {
            this.birtAggregationDisplayName = this.getAggregationDisplayName(this.birtAggregationId);
        }
    }

    private String getAggregationDisplayName(String aggregationId) {
        IChoiceSet allowedChoices = MetaDataDictionary.getInstance().getChoiceSet("aggregationFunction");
        assert (allowedChoices != null);
        IChoice choice = allowedChoices.findChoice(this.birtAggregationId);
        if (choice != null) {
            return choice.getDisplayName();
        }
        return null;
    }
}

