/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.command;

import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;

public class ViewsContentEvent
extends NotificationEvent {
    public static final int ADD = 10;
    public static final int REMOVE = 11;
    public static final int SHIFT = 12;
    private int action;
    private DesignElement content;
    protected ContainerContext focus = null;

    public ViewsContentEvent(ContainerContext containerInfo, DesignElement theContent, int theAction) {
        super(containerInfo.getElement());
        this.action = theAction;
        this.content = theContent;
        this.focus = containerInfo;
    }

    public int getEventType() {
        return 24;
    }

    public int getAction() {
        return this.action;
    }

    public IDesignElement getContent() {
        return this.content;
    }

    public boolean isSame(NotificationEvent event) {
        if (!super.isSame(event)) {
            return false;
        }
        ViewsContentEvent contentEvent = (ViewsContentEvent)event;
        return this.action == contentEvent.getAction() && this.focus.equals(contentEvent.focus) && this.content == contentEvent.getContent();
    }
}

