/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetHandleAdapter;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.IThemeModel;

public class ThemeHandle
extends AbstractThemeHandle
implements IThemeModel {
    public ThemeHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public List getAllCssStyleSheets() {
        Theme theme = (Theme)this.getElement();
        ArrayList<CssStyleSheetHandle> allStyles = new ArrayList<CssStyleSheetHandle>();
        List<CssStyleSheet> csses = theme.getCsses();
        int i = 0;
        while (csses != null && i < csses.size()) {
            CssStyleSheet sheet = csses.get(i);
            allStyles.add(sheet.handle(this.getModule()));
            ++i;
        }
        return allStyles;
    }

    public void addCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(sheetHandle);
    }

    public void addCss(IncludedCssStyleSheet cssStruct) throws SemanticException {
        if (cssStruct == null) {
            return;
        }
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(cssStruct);
    }

    public void addCss(String fileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(fileName);
    }

    public void dropCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.dropCss(sheetHandle);
    }

    public boolean canDropCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canDropCssStyleSheet(sheetHandle);
    }

    public boolean canAddCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(sheetHandle);
    }

    public boolean canAddCssStyleSheet(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(fileName);
    }

    public void reloadCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.reloadCss(sheetHandle);
    }

    public CssStyleSheetHandle findCssStyleSheetHandleByName(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findCssStyleSheetHandleByFileName(fileName);
    }

    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByName(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findIncludedCssStyleSheetHandleByFileName(fileName);
    }

    public void renameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.renameCss(handle, newFileName);
    }

    public boolean canRenameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canRenameCss(handle, newFileName);
    }
}

