/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDERegistration;
import org.eclipse.jst.jsf.common.internal.types.TypeInfoCache;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorTypeInfo;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.JSFCoreTraceOptions;
import org.eclipse.jst.jsf.core.internal.jem.BeanProxyUtil;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTComponentIntrospector {
    private static TypeInfoCache TYPE_CACHE;

    public static TypeInfoCache getSharedTypeCache() {
        if (TYPE_CACHE == null) {
            TYPE_CACHE = TypeInfoCache.createNewInstance();
        }
        return TYPE_CACHE;
    }

    public static ComponentTypeInfo getComponent(String classType, String className, IProject project, IConfigurationContributor[] contributors) {
        block11: {
            ProxyFactoryRegistry registry = null;
            try {
                String renderer;
                String family;
                block12: {
                    registry = DTComponentIntrospector.getProxyFactoryRegistry(project, contributors);
                    if (registry == null) break block11;
                    IStandardBeanTypeProxyFactory factory = registry.getBeanTypeProxyFactory();
                    IBeanTypeProxy classTypeProxy = factory.getBeanTypeProxy(className);
                    BeanProxyUtil.BeanProxyWrapper classTypeWrapper = new BeanProxyUtil.BeanProxyWrapper(project, classTypeProxy);
                    family = null;
                    renderer = null;
                    try {
                        classTypeWrapper.init();
                        family = classTypeWrapper.callStringMethod("getFamily");
                        renderer = classTypeWrapper.callStringMethod("getRendererType");
                    }
                    catch (BeanProxyUtil.ProxyException e1) {
                        if (!JSFCoreTraceOptions.TRACE_JSPTAGINTROSPECTOR) break block12;
                        JSFCoreTraceOptions.log("DTComponentIntrospector.getComponent:", e1);
                    }
                }
                IType type = null;
                try {
                    type = JavaCore.create((IProject)project).findType(className);
                }
                catch (JavaModelException javaModelException) {}
                ArrayList<String> interfaces = new ArrayList<String>();
                ArrayList<String> superClasses = new ArrayList<String>();
                if (type != null) {
                    IType[] superClassTypes;
                    IType[] interfaceTypes;
                    TypeInfoCache typeCache = DTComponentIntrospector.getSharedTypeCache();
                    IType[] iTypeArray = interfaceTypes = typeCache.cacheInterfaceTypesFor(type);
                    int n = interfaceTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType interfaze = iTypeArray[n2];
                        interfaces.add(interfaze.getFullyQualifiedName());
                        ++n2;
                    }
                    IType[] iTypeArray2 = superClassTypes = typeCache.cacheSupertypesFor(type);
                    int n3 = superClassTypes.length;
                    n = 0;
                    while (n < n3) {
                        IType superClass = iTypeArray2[n];
                        superClasses.add(superClass.getFullyQualifiedName());
                        ++n;
                    }
                }
                ComponentTypeInfo componentTypeInfo = new ComponentTypeInfo(classType, className, superClasses.toArray(new String[0]), interfaces.toArray(new String[0]), family, renderer);
                return componentTypeInfo;
            }
            finally {
                if (registry != null) {
                    registry.terminateRegistry(true);
                }
            }
        }
        return null;
    }

    public static ComponentTypeInfo getComponent(String classType, String className, IProject project) {
        return DTComponentIntrospector.getComponent(classType, className, project, null);
    }

    public static ConverterTypeInfo getConverter(String converterId, String converterClass) {
        return new ConverterTypeInfo(converterClass, converterId);
    }

    public static ValidatorTypeInfo getValidator(String validatorId, String validatorClass) {
        return new ValidatorTypeInfo(validatorClass, validatorId);
    }

    public static String findComponentClass(String componentType, IProject project) {
        IJSFAppConfigManager manager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance(project);
        List<ComponentType> components = manager.getComponents();
        for (ComponentType component : components) {
            String type = component.getComponentType().getTextContent().trim();
            if (!componentType.equals(type)) continue;
            return component.getComponentClass().getTextContent().trim();
        }
        return null;
    }

    public static String findConverterClass(String converterId, IProject project) {
        IJSFAppConfigManager manager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance(project);
        List<ConverterType> converters = manager.getConverters();
        for (ConverterType converter : converters) {
            String type;
            if (converter == null || converter.getConverterId() == null || converter.getConverterId().getTextContent() == null || !converterId.equals(type = converter.getConverterId().getTextContent().trim())) continue;
            if (converter.getConverterClass() != null && converter.getConverterClass().getTextContent() != null) {
                return converter.getConverterClass().getTextContent().trim();
            }
            return null;
        }
        return null;
    }

    public static String findValidatorClass(String validatorId, IProject project) {
        IJSFAppConfigManager manager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance(project);
        List<ValidatorType> validators = manager.getValidators();
        for (ValidatorType validatorType : validators) {
            String type;
            if (validatorType == null || validatorType.getValidatorId() == null || validatorType.getValidatorId().getTextContent() == null || !validatorId.equals(type = validatorType.getValidatorId().getTextContent().trim())) continue;
            return validatorType.getValidatorClass().getTextContent().trim();
        }
        return null;
    }

    public static boolean isTypeNameInstanceOfClass(IType type, Set<String> checkInstanceOf) {
        if (checkInstanceOf == null) {
            throw new AssertionError();
        }
        if (type != null) {
            if (checkInstanceOf.contains(type.getFullyQualifiedName())) {
                return true;
            }
            IType[] iTypeArray = DTComponentIntrospector.getSharedTypeCache().cacheSupertypesFor(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType supertype = iTypeArray[n2];
                if (checkInstanceOf.contains(supertype.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
            iTypeArray = DTComponentIntrospector.getSharedTypeCache().cacheInterfaceTypesFor(type);
            n = iTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                IType interfaces = iTypeArray[n2];
                if (checkInstanceOf.contains(interfaces.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Map<String, JDTBeanProperty> getBeanProperties(ComponentTypeInfo typeInfo, IProject project) {
        Map<String, Object> properties = new HashMap<String, JDTBeanProperty>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IType type = javaProject.findType(typeInfo.getClassName());
            if (type != null) {
                JDTBeanIntrospector introspector = new JDTBeanIntrospector(type);
                properties = introspector.getProperties();
            }
        }
        catch (JavaModelException e) {
            JSFCorePlugin.log("Error finding component type", e);
        }
        return properties;
    }

    private static ProxyFactoryRegistry getProxyFactoryRegistry(IProject project, IConfigurationContributor[] contributors) {
        try {
            return IDERegistration.startAnImplementation((IConfigurationContributor[])contributors, (boolean)false, (IProject)project, (String)project.getName(), (String)"org.eclipse.jst.jsf.core", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JSFCorePlugin.log("Error starting vm for project: " + project.getName(), e);
            return null;
        }
    }

    private DTComponentIntrospector() {
    }
}

