/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JSFAppConfigUtils {
    public static final String CONFIG_FILES_CONTEXT_PARAM_NAME = "javax.faces.CONFIG_FILES";
    public static final String FACES_CONFIG_IN_JAR_PATH = "META-INF/faces-config.xml";

    public static boolean isValidJSFProject(IProject project, String minVersion) {
        boolean isValid = false;
        IProjectFacetVersion projectFacetVersion = JSFAppConfigUtils.getProjectFacet(project);
        if (projectFacetVersion != null) {
            try {
                String versionString = projectFacetVersion.getVersionString();
                Comparator comparator = projectFacetVersion.getProjectFacet().getVersionComparator();
                int compareToMin = comparator.compare(versionString, minVersion);
                if (compareToMin >= 0) {
                    return true;
                }
            }
            catch (CoreException ce) {
                JSFCorePlugin.log((Exception)((Object)ce), "Error checking facet version");
            }
        }
        return isValid;
    }

    public static boolean isValidJSFProject(IProject project) {
        boolean isValid = false;
        IProjectFacetVersion projectFacet = JSFAppConfigUtils.getProjectFacet(project);
        if (projectFacet != null) {
            isValid = true;
        }
        return isValid;
    }

    public static IProjectFacetVersion getProjectFacet(IProject project) {
        if (project != null && project.isAccessible()) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null) {
                    Set projectFacets = facetedProject.getProjectFacets();
                    for (IProjectFacetVersion projectFacetVersion : projectFacets) {
                        if (!"jst.jsf".equals(projectFacetVersion.getProjectFacet().getId())) continue;
                        return projectFacetVersion;
                    }
                }
            }
            catch (CoreException ce) {
                JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
            }
        }
        return null;
    }

    public static IVirtualFolder getWebContentFolder(IProject project) {
        return new AbstractVirtualComponentQuery.DefaultVirtualComponentQuery().getWebContentFolder(project);
    }

    public static IPath getWebContentFolderRelativePath(IFile file) {
        IVirtualFolder webContentFolder;
        IPath path = null;
        if (file != null && (webContentFolder = JSFAppConfigUtils.getWebContentFolder(file.getProject())) != null) {
            IPath webContentPath = webContentFolder.getProjectRelativePath();
            IPath filePath = file.getProjectRelativePath();
            int matchingFirstSegments = webContentPath.matchingFirstSegments(filePath);
            path = filePath.removeFirstSegments(matchingFirstSegments);
        }
        return path;
    }

    public static List getConfigFilesFromContextParam(IProject project) {
        IModelProvider provider;
        Object webAppObj;
        List filesList = Collections.EMPTY_LIST;
        if (JSFAppConfigUtils.isValidJSFProject(project) && (webAppObj = (provider = ModelProviderManager.getModelProvider((IProject)project)).getModelObject()) != null) {
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                filesList = JSFAppConfigUtils.getConfigFilesForJ2EEApp(project);
            } else if (webAppObj instanceof WebApp) {
                filesList = JSFAppConfigUtils.getConfigFilesForJEEApp((WebApp)webAppObj);
            }
        }
        return filesList;
    }

    private static List getConfigFilesForJEEApp(WebApp webApp) {
        String filesString = null;
        List contextParams = webApp.getContextParams();
        for (org.eclipse.jst.javaee.core.ParamValue paramValue : contextParams) {
            if (!paramValue.getParamName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
            filesString = paramValue.getParamValue();
            break;
        }
        return JSFAppConfigUtils.parseFilesString(filesString);
    }

    private static List getConfigFilesForJ2EEApp(IProject project) {
        List filesList;
        block11: {
            filesList = new ArrayList();
            WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
            if (webArtifactEdit != null) {
                try {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = null;
                    try {
                        webApp = webArtifactEdit.getWebApp();
                    }
                    catch (ClassCastException cce) {
                        JSFCorePlugin.log(4, cce.getLocalizedMessage(), cce);
                        ArrayList arrayList = filesList;
                        webArtifactEdit.dispose();
                        return arrayList;
                    }
                    if (webApp == null) break block11;
                    String filesString = null;
                    if (webApp.getVersionID() == 23) {
                        EList contexts = webApp.getContexts();
                        for (ContextParam contextParam : contexts) {
                            if (!contextParam.getParamName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
                            filesString = contextParam.getParamValue();
                            break;
                        }
                    } else {
                        EList contextParams = webApp.getContextParams();
                        for (ParamValue paramValue : contextParams) {
                            if (!paramValue.getName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
                            filesString = paramValue.getValue();
                            break;
                        }
                    }
                    filesList = JSFAppConfigUtils.parseFilesString(filesString);
                }
                finally {
                    webArtifactEdit.dispose();
                }
            }
        }
        return filesList;
    }

    private static List parseFilesString(String filesString) {
        ArrayList<String> filesList = new ArrayList<String>();
        if (filesString != null && filesString.trim().length() > 0) {
            StringTokenizer stFilesString = new StringTokenizer(filesString, ",");
            while (stFilesString.hasMoreTokens()) {
                String configFile = stFilesString.nextToken().trim();
                filesList.add(configFile);
            }
        }
        return filesList;
    }

    public static List getConfigFileJARsFromClasspath(IProject project) throws CoreException, IOException {
        IClasspathEntry[] classpathEntries;
        IJavaProject javaProject;
        ArrayList<String> JARsList = new ArrayList<String>();
        if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature") && (javaProject = JavaCore.create((IProject)project)) != null && (classpathEntries = javaProject.getResolvedClasspath(true)) != null && classpathEntries.length > 0) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < classpathEntries.length) {
                block14: {
                    IPath libraryPath;
                    IClasspathEntry classpathEntry = classpathEntries[i];
                    if (classpathEntry.getEntryKind() == 1 && (libraryPath = classpathEntry.getPath()).getFileExtension() != null && libraryPath.getFileExtension().length() > 0) {
                        if (libraryPath.getDevice() == null && workspaceRoot.getProject(libraryPath.segment(0)).exists()) {
                            libraryPath = workspaceRoot.getFile(libraryPath).getLocation();
                        }
                        String libraryPathString = libraryPath.toString();
                        ZipFile jarFile = null;
                        try {
                            JarEntry jarEntry;
                            File file = new File(libraryPathString);
                            if (file.exists() && (jarEntry = ((JarFile)(jarFile = new JarFile(file, false))).getJarEntry(FACES_CONFIG_IN_JAR_PATH)) != null) {
                                JARsList.add(libraryPathString);
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (jarFile != null) {
                                jarFile.close();
                            }
                            break block14;
                        }
                        catch (IOException ioe) {
                            try {
                                JSFCorePlugin.log(4, NLS.bind((String)Messages.JSFAppConfigUtils_ErrorOpeningJarFile, (Object)libraryPathString), ioe);
                                break block14;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (jarFile != null) {
                                    jarFile.close();
                                }
                            }
                        }
                        if (jarFile == null) break block14;
                        jarFile.close();
                    }
                }
                ++i;
            }
        }
        return JARsList;
    }
}

