/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.memento;

import java.util.LinkedList;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoBuilder;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoElement;
import org.eclipse.ui.IMemento;

public class Memento
implements IMemento {
    protected MementoElement memento;
    private MementoBuilder builder;

    public Memento(MementoElement memento, MementoBuilder builder) {
        this.memento = memento;
        this.builder = builder;
    }

    public IMemento createChild(String id) {
        return null;
    }

    public IMemento createChild(String id, String type) {
        MementoElement child = this.builder.createElement(id, type);
        this.memento.addChild(child);
        return this.builder.createMemento(child);
    }

    public IMemento getChild(String id) {
        MementoElement[] children = this.memento.getChildren();
        int size = children.length;
        if (size == 0) {
            return null;
        }
        int nX = 0;
        while (nX < size) {
            MementoElement element = children[nX];
            if (element.getKey().equals(id)) {
                return this.builder.createMemento(element);
            }
            ++nX;
        }
        return null;
    }

    public IMemento[] getChildren(String id) {
        MementoElement[] children = this.memento.getChildren();
        int size = children.length;
        if (size == 0) {
            return new Memento[0];
        }
        LinkedList<IMemento> mementoList = new LinkedList<IMemento>();
        int nX = 0;
        while (nX < size) {
            MementoElement element = children[nX];
            if (element.getKey().equals(id)) {
                mementoList.add(this.builder.createMemento(element));
            }
            ++nX;
        }
        IMemento[] mementos = new IMemento[mementoList.size()];
        mementoList.toArray(mementos);
        return mementos;
    }

    public IMemento[] getChildren() {
        MementoElement[] children = this.memento.getChildren();
        int size = children.length;
        if (size == 0) {
            return new Memento[0];
        }
        IMemento[] mementos = new IMemento[size];
        int nX = 0;
        while (nX < size) {
            MementoElement element = children[nX];
            mementos[nX] = this.builder.createMemento(element);
            ++nX;
        }
        return mementos;
    }

    public Float getFloat(String key) {
        Object value = this.memento.getAttribute(key);
        if (value != null) {
            try {
                return new Float(value.toString());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public String getID() {
        return this.memento.getKey();
    }

    public Integer getInteger(String key) {
        Object value = this.memento.getAttribute(key);
        if (value != null) {
            try {
                return new Integer(value.toString());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public String getString(String key) {
        Object value = this.memento.getAttribute(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public String getTextData() {
        Object value = this.memento.getValue();
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public void putFloat(String key, float value) {
    }

    public void putInteger(String key, int value) {
    }

    public void putMemento(IMemento memento) {
    }

    public void putString(String key, String value) {
    }

    public void putTextData(String data) {
    }

    public MementoElement getMementoElement() {
        return this.memento;
    }

    public MementoBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(MementoBuilder builder) {
        this.builder = builder;
    }

    public String[] getAttributeKeys() {
        return null;
    }

    public Boolean getBoolean(String key) {
        return null;
    }

    public String getType() {
        return null;
    }

    public void putBoolean(String key, boolean value) {
    }
}

