/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionModelStateSerializer {
    private final SelectionModel selectionModel;
    private final MarketplaceCatalog catalog;

    public SelectionModelStateSerializer(MarketplaceCatalog catalog, SelectionModel selectionModel) {
        this.catalog = catalog;
        this.selectionModel = selectionModel;
    }

    public String serialize() {
        StringBuilder state = new StringBuilder(1024);
        for (Map.Entry<CatalogItem, Operation> entry : this.selectionModel.getItemToOperation().entrySet()) {
            if (entry.getValue() == Operation.NONE) continue;
            if (state.length() > 0) {
                state.append(' ');
            }
            Node data = (Node)entry.getKey().getData();
            state.append(data.getId());
            state.append('=');
            state.append(entry.getValue().name());
        }
        return state.toString();
    }

    public void deserialize(IProgressMonitor monitor, String state, Map<String, Operation> operationByNodeIdExtras) {
        HashMap<String, Operation> operationByNodeId = new HashMap<String, Operation>();
        if (state != null && state.length() > 0) {
            Pattern pattern = Pattern.compile("([^\\s=]+)=(\\S+)");
            Matcher matcher = pattern.matcher(state);
            while (matcher.find()) {
                String nodeId = matcher.group(1);
                String operationName = matcher.group(2);
                Operation operation = Operation.valueOf(operationName);
                operationByNodeId.put(nodeId, operation);
            }
        }
        if (operationByNodeIdExtras != null) {
            operationByNodeId.putAll(operationByNodeIdExtras);
        }
        if (!operationByNodeId.isEmpty()) {
            this.catalog.performQuery(monitor, operationByNodeId.keySet());
            for (CatalogItem item : this.catalog.getItems()) {
                MarketplaceNodeCatalogItem nodeItem;
                Operation operation;
                if (!(item instanceof MarketplaceNodeCatalogItem) || (operation = (Operation)((Object)operationByNodeId.get((nodeItem = (MarketplaceNodeCatalogItem)item).getData().getId()))) == null || operation == Operation.NONE) continue;
                if (nodeItem.isInstalled() && operation == Operation.INSTALL) {
                    operation = Operation.CHECK_FOR_UPDATES;
                }
                this.selectionModel.select(nodeItem, operation);
            }
        }
    }

    public void deserialize(IProgressMonitor monitor, String state) {
        this.deserialize(monitor, state, null);
    }
}

