/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;
import org.eclipse.ui.views.bookmarkexplorer.MarkerUtil;

class CopyBookmarkAction
extends BookmarkAction {
    public CopyBookmarkAction(BookmarkNavigator bookmarkNavigator) {
        super(bookmarkNavigator, BookmarkMessages.CopyBookmark_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.copy_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        BookmarkNavigator bookmarkNavigator = this.getView();
        StructuredViewer viewer = bookmarkNavigator.getViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        List list = selection.toList();
        IMarker[] markers = new IMarker[list.size()];
        list.toArray(markers);
        this.setClipboard(markers, this.createBookmarkReport(markers));
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.setEnabled(!sel.isEmpty());
    }

    private void setClipboard(IMarker[] markers, String markerReport) {
        block3: {
            try {
                Object[] data = new Object[]{markers, markerReport};
                Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
                this.getView().getClipboard().setContents(data, transferTypes);
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getView().getShell(), (String)BookmarkMessages.CopyToClipboardProblemDialog_title, (String)BookmarkMessages.CopyToClipboardProblemDialog_message)) break block3;
                this.setClipboard(markers, markerReport);
            }
        }
    }

    private String createBookmarkReport(IMarker[] markers) {
        String report = "";
        report = String.valueOf(report) + BookmarkMessages.ColumnDescription_header + '\t';
        report = String.valueOf(report) + BookmarkMessages.ColumnResource_header + '\t';
        report = String.valueOf(report) + BookmarkMessages.ColumnFolder_header + '\t';
        report = String.valueOf(report) + BookmarkMessages.ColumnLocation_header;
        report = String.valueOf(report) + System.getProperty("line.separator");
        int i = 0;
        while (i < markers.length) {
            report = String.valueOf(report) + MarkerUtil.getMessage(markers[i]) + '\t';
            report = String.valueOf(report) + MarkerUtil.getResourceName(markers[i]) + '\t';
            report = String.valueOf(report) + MarkerUtil.getContainerName(markers[i]) + '\t';
            int line = MarkerUtil.getLineNumber(markers[i]);
            report = String.valueOf(report) + NLS.bind((String)BookmarkMessages.LineIndicator_text, (Object)String.valueOf(line));
            report = String.valueOf(report) + System.getProperty("line.separator");
            ++i;
        }
        return report;
    }
}

